/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.equinox.internal.app;

import java.security.Guard;
import java.security.GuardedObject;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eclipse.equinox.internal.app.Activator;
import org.greenrobot.eclipse.equinox.internal.app.AppPersistence;
import org.greenrobot.eclipse.equinox.internal.app.Messages;
import org.greenrobot.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.InvalidSyntaxException;
import org.greenrobot.osgi.framework.ServiceRegistration;
import org.greenrobot.osgi.service.application.ApplicationDescriptor;
import org.greenrobot.osgi.service.application.ScheduledApplication;
import org.greenrobot.osgi.service.event.Event;
import org.greenrobot.osgi.service.event.EventHandler;
import org.greenrobot.osgi.service.event.TopicPermission;
import org.greenrobot.osgi.util.tracker.ServiceTracker;

public class EclipseScheduledApplication
implements ScheduledApplication,
EventHandler {
    private static final String FILTER_PREFIX = "(&(objectclass=" + ApplicationDescriptor.class.getName() + ")(" + "service.pid" + "=";
    private static final String FILTER_POSTFIX = "))";
    private boolean recurring;
    private String topic;
    private String eventFilter;
    private Map<String, Object> args;
    private String appPid;
    private String id;
    private ServiceRegistration sr;
    private ServiceTracker appTracker;
    private boolean removed = false;

    EclipseScheduledApplication(BundleContext context, String id, String appPid, Map<String, Object> args, String topic, String eventFilter, boolean recurring) throws InvalidSyntaxException {
        this.id = id;
        this.appPid = appPid;
        this.args = args;
        this.topic = topic == null || topic.trim().equals("") || topic.trim().equals("*") ? null : topic;
        this.eventFilter = eventFilter;
        this.recurring = recurring;
        this.appTracker = new ServiceTracker(context, context.createFilter(String.valueOf(FILTER_PREFIX) + appPid + FILTER_POSTFIX), null);
        Activator.openTracker(this.appTracker, false);
    }

    @Override
    public String getScheduleId() {
        return this.id;
    }

    String getAppPid() {
        return this.appPid;
    }

    @Override
    public synchronized String getTopic() {
        if (this.removed) {
            throw new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.topic;
    }

    @Override
    public synchronized String getEventFilter() {
        if (this.removed) {
            throw new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.eventFilter;
    }

    @Override
    public synchronized boolean isRecurring() {
        if (this.removed) {
            throw new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.recurring;
    }

    @Override
    public synchronized ApplicationDescriptor getApplicationDescriptor() {
        if (this.removed) {
            throw new IllegalStateException(Messages.scheduled_app_removed);
        }
        return (ApplicationDescriptor)Activator.getService(this.appTracker);
    }

    @Override
    public synchronized Map<String, Object> getArguments() {
        if (this.removed) {
            throw new IllegalStateException(Messages.scheduled_app_removed);
        }
        return this.args == null ? null : new HashMap<String, Object>(this.args);
    }

    private Map<String, Object> getArguments(Event trigger) {
        Map<Object, Object> result = this.args == null ? new HashMap() : this.getArguments();
        result.put("org.greenrobot.osgi.triggeringevent", new GuardedObject(trigger, new TriggerGuard(trigger.getTopic())));
        return result;
    }

    @Override
    public synchronized void remove() {
        if (this.removed) {
            return;
        }
        this.removed = true;
        AppPersistence.removeScheduledApp(this);
        if (this.sr != null) {
            this.sr.unregister();
        }
        this.sr = null;
        this.appTracker.close();
    }

    public synchronized void handleEvent(Event event) {
        try {
            if (this.removed) {
                return;
            }
            ApplicationDescriptor desc = this.getApplicationDescriptor();
            if (desc == null) {
                return;
            }
            desc.launch(this.getArguments(event));
        }
        catch (Exception e) {
            String message = NLS.bind(Messages.scheduled_app_launch_error, this.sr);
            Activator.log(new FrameworkLogEntry("org.greenrobot.eclipse.equinox.app", 2, 0, message, 0, e, null));
            return;
        }
        if (!this.isRecurring()) {
            this.remove();
        }
    }

    synchronized void setServiceRegistration(ServiceRegistration sr) {
        this.sr = sr;
        if (this.removed) {
            sr.unregister();
        }
    }

    public class TriggerGuard
    implements Guard {
        String eventTopic;

        public TriggerGuard(String topic) {
            this.eventTopic = topic;
        }

        @Override
        public void checkGuard(Object object) throws SecurityException {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new TopicPermission(this.eventTopic, "subscribe"));
            }
        }
    }
}

