/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.greenrobot.eclipse.core.resources.IBuildConfiguration;
import org.greenrobot.eclipse.core.resources.IDynamicReferenceProvider;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.IWorkspaceRoot;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.jdt.core.IJavaProject;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;

public class DynamicProjectReferences
implements IDynamicReferenceProvider {
    @Override
    public List<IProject> getDependentProjects(IBuildConfiguration buildConfiguration) throws CoreException {
        IProject input = buildConfiguration.getProject();
        IJavaProject javaProject = JavaCore.create(input);
        if (javaProject instanceof JavaProject) {
            JavaProject project = (JavaProject)javaProject;
            String[] required = project.projectPrerequisites(project.getResolvedClasspath());
            IWorkspaceRoot wksRoot = input.getWorkspace().getRoot();
            return Arrays.stream(required).sorted().map(name -> wksRoot.getProject((String)name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

