/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.jdt.core.ClasspathContainerInitializer;
import org.greenrobot.eclipse.jdt.core.IClasspathContainer;
import org.greenrobot.eclipse.jdt.core.IJavaProject;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.internal.core.JavaModelManager;
import org.greenrobot.eclipse.jdt.internal.core.JavaProject;
import org.greenrobot.eclipse.jdt.internal.core.ModulePathContainer;
import org.greenrobot.eclipse.jdt.internal.core.util.Util;

public class ModulePathContainerInitializer
extends ClasspathContainerInitializer {
    @Override
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (this.isModulePathContainer(containerPath)) {
            if (project instanceof JavaProject) {
                ModulePathContainer container = new ModulePathContainer(project);
                JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container}, null);
            }
        } else if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
            this.verbose_not_a_module_project(project, containerPath);
        }
    }

    private boolean isModulePathContainer(IPath path) {
        return path != null && "org.greenrobot.eclipse.jdt.MODULE_PATH".equals(path.segment(0));
    }

    private void verbose_not_a_module_project(IJavaProject project, IPath containerPath) {
        Util.verbose("Module path INIT - FAILED (not a module project)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath);
    }
}

