/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportComment;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportDeclarationWriter;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportEntry;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportGroupComparator;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.OriginalImportEntry;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.RemovedImportCommentReassigner;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.RewriteSite;
import org.greenrobot.eclipse.jface.text.IRegion;
import org.greenrobot.eclipse.text.edits.DeleteEdit;
import org.greenrobot.eclipse.text.edits.InsertEdit;
import org.greenrobot.eclipse.text.edits.MoveSourceEdit;
import org.greenrobot.eclipse.text.edits.MoveTargetEdit;
import org.greenrobot.eclipse.text.edits.MultiTextEdit;
import org.greenrobot.eclipse.text.edits.RangeMarker;
import org.greenrobot.eclipse.text.edits.ReplaceEdit;
import org.greenrobot.eclipse.text.edits.TextEdit;

final class ImportEditor {
    private final String lineDelimiter;
    private final String twoLineDelimiters;
    private final boolean fixAllLineDelimiters;
    private final int lineDelimitersBetweenImportGroups;
    private final ImportGroupComparator importGroupComparator;
    private final RemovedImportCommentReassigner commentReassigner;
    private final Map<ImportName, ImportEntry> originalPrecedingImports;
    private final List<OriginalImportEntry> originalImportEntries;
    private final RewriteSite rewriteSite;
    private final ImportDeclarationWriter declarationWriter;

    private static Map<ImportName, ImportEntry> mapPrecedingImports(Collection<? extends ImportEntry> importEntries) {
        IdentityHashMap<ImportName, ImportEntry> precedingImports = new IdentityHashMap<ImportName, ImportEntry>(importEntries.size());
        ImportEntry previousImport = null;
        for (ImportEntry importEntry : importEntries) {
            ImportName currentImportName = importEntry.importName;
            precedingImports.put(currentImportName, previousImport);
            previousImport = importEntry;
        }
        return precedingImports;
    }

    private static boolean containsFloatingComment(Iterable<ImportComment> comments) {
        for (ImportComment comment : comments) {
            if (comment.succeedingLineDelimiters <= 1) continue;
            return true;
        }
        return false;
    }

    ImportEditor(String lineDelimiter, boolean fixAllLineDelimiters, int lineDelimitersBetweenImportGroups, ImportGroupComparator importGroupComparator, List<OriginalImportEntry> originalImports, RewriteSite rewriteSite, ImportDeclarationWriter importDeclarationWriter) {
        this.lineDelimiter = lineDelimiter;
        this.twoLineDelimiters = this.lineDelimiter.concat(this.lineDelimiter);
        this.fixAllLineDelimiters = fixAllLineDelimiters;
        this.lineDelimitersBetweenImportGroups = lineDelimitersBetweenImportGroups;
        this.importGroupComparator = importGroupComparator;
        this.originalImportEntries = originalImports;
        this.rewriteSite = rewriteSite;
        this.declarationWriter = importDeclarationWriter;
        this.commentReassigner = new RemovedImportCommentReassigner(originalImports);
        this.originalPrecedingImports = fixAllLineDelimiters ? Collections.emptyMap() : Collections.unmodifiableMap(ImportEditor.mapPrecedingImports(originalImports));
    }

    TextEdit createTextEdit(Collection<ImportEntry> resultantImports) {
        MultiTextEdit edit = new MultiTextEdit();
        IRegion surroundingRegion = this.rewriteSite.surroundingRegion;
        if (resultantImports.isEmpty()) {
            if (!this.originalImportEntries.isEmpty()) {
                String newWhitespace;
                if (this.rewriteSite.hasPrecedingElements) {
                    int newDelims = this.rewriteSite.hasSucceedingElements ? 2 : 1;
                    newWhitespace = this.createDelimiter(newDelims);
                } else {
                    newWhitespace = "";
                }
                edit.addChild(new ReplaceEdit(surroundingRegion.getOffset(), surroundingRegion.getLength(), newWhitespace));
            }
        } else if (this.originalImportEntries.isEmpty()) {
            Collection<TextEdit> importEdits = this.determineEditsForImports(surroundingRegion, resultantImports);
            if (this.rewriteSite.hasPrecedingElements) {
                edit.addChild(new InsertEdit(surroundingRegion.getOffset(), this.createDelimiter(2)));
            }
            edit.addChildren(importEdits.toArray(new TextEdit[importEdits.size()]));
            int newSucceedingDelims = this.rewriteSite.hasSucceedingElements ? 2 : 1;
            String newSucceeding = this.createDelimiter(newSucceedingDelims);
            edit.addChild(new InsertEdit(surroundingRegion.getOffset(), newSucceeding));
        } else {
            Collection<TextEdit> importEdits = this.determineEditsForImports(this.rewriteSite.importsRegion, resultantImports);
            edit.addChildren(importEdits.toArray(new TextEdit[importEdits.size()]));
        }
        return edit;
    }

    private String createDelimiter(int numberOfLineDelimiters) {
        if (numberOfLineDelimiters < 1) {
            throw new IllegalArgumentException();
        }
        if (numberOfLineDelimiters == 1) {
            return this.lineDelimiter;
        }
        if (numberOfLineDelimiters == 2) {
            return this.twoLineDelimiters;
        }
        StringBuilder correctDelimiter = new StringBuilder();
        int i = 0;
        while (i < numberOfLineDelimiters) {
            correctDelimiter.append(this.lineDelimiter);
            ++i;
        }
        return correctDelimiter.toString();
    }

    private Collection<TextEdit> determineEditsForImports(IRegion importsRegion, Collection<ImportEntry> resultantImports) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Map<ImportEntry, Collection<ImportComment>> commentReassignments = this.commentReassigner.reassignComments(resultantImports);
        OriginalImportsCursor cursor = new OriginalImportsCursor(importsRegion.getOffset(), this.originalImportEntries);
        edits.addAll(this.placeResultantImports(cursor, resultantImports, commentReassignments));
        edits.addAll(ImportEditor.deleteRemainingText(importsRegion, edits));
        ArrayList<TextEdit> editsWithoutRangeMarkers = new ArrayList<TextEdit>(edits.size());
        for (TextEdit edit : edits) {
            if (edit instanceof RangeMarker) continue;
            editsWithoutRangeMarkers.add(edit);
        }
        return editsWithoutRangeMarkers;
    }

    private Collection<TextEdit> placeResultantImports(OriginalImportsCursor cursor, Collection<ImportEntry> resultantImports, Map<ImportEntry, Collection<ImportComment>> commentReassignments) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        ImportEntry lastResultantImport = null;
        for (ImportEntry currentResultantImport : resultantImports) {
            ImportEdits importPlacement;
            Collection<ImportComment> reassignedComments;
            if (currentResultantImport.isOriginal()) {
                while (cursor.currentOriginalImport != null && cursor.currentOriginalImport != currentResultantImport) {
                    cursor.advance();
                }
            }
            if ((reassignedComments = commentReassignments.get(currentResultantImport)) == null) {
                reassignedComments = Collections.emptyList();
            }
            if (currentResultantImport.isOriginal()) {
                OriginalImportEntry originalImport = currentResultantImport.asOriginalImportEntry();
                importPlacement = cursor.currentOriginalImport == currentResultantImport ? this.preserveStationaryImport(originalImport) : this.moveOriginalImport(originalImport, cursor.currentPosition);
            } else {
                importPlacement = this.placeNewImport(currentResultantImport, cursor.currentPosition);
            }
            String newDelimiter = this.determineNewDelimiter(lastResultantImport, currentResultantImport, reassignedComments);
            if (newDelimiter == null) {
                edits.addAll(importPlacement.leadingDelimiterEdits);
            } else if (!newDelimiter.isEmpty()) {
                edits.add(new InsertEdit(cursor.currentPosition, newDelimiter));
            }
            if (!reassignedComments.isEmpty()) {
                edits.addAll(this.relocateComments(reassignedComments, cursor.currentPosition));
                boolean hasFloatingComment = currentResultantImport.isOriginal() && ImportEditor.containsFloatingComment(currentResultantImport.asOriginalImportEntry().comments);
                String delimiterAfterReassignedComments = hasFloatingComment ? this.twoLineDelimiters : this.lineDelimiter;
                edits.add(new InsertEdit(cursor.currentPosition, delimiterAfterReassignedComments));
            }
            edits.addAll(importPlacement.commentAndDeclarationEdits);
            if (currentResultantImport == cursor.currentOriginalImport) {
                cursor.advance();
            }
            lastResultantImport = currentResultantImport;
        }
        return edits;
    }

    private ImportEdits placeNewImport(ImportEntry currentResultantImport, int position) {
        String declaration = this.declarationWriter.writeImportDeclaration(currentResultantImport.importName);
        return new ImportEdits(Collections.emptySet(), Collections.singleton(new InsertEdit(position, declaration)));
    }

    private ImportEdits moveOriginalImport(OriginalImportEntry importEntry, int position) {
        MoveSourceEdit leadingSourceEdit = new MoveSourceEdit(importEntry.leadingDelimiter.getOffset(), importEntry.leadingDelimiter.getLength());
        MoveTargetEdit leadingTargetEdit = new MoveTargetEdit(position, leadingSourceEdit);
        List<TextEdit> leadingDelimiterEdits = Arrays.asList(leadingSourceEdit, leadingTargetEdit);
        MoveSourceEdit importSourceEdit = new MoveSourceEdit(importEntry.declarationAndComments.getOffset(), importEntry.declarationAndComments.getLength());
        MoveTargetEdit importTargetEdit = new MoveTargetEdit(position, importSourceEdit);
        List<TextEdit> declarationAndCommentEdits = Arrays.asList(importSourceEdit, importTargetEdit);
        return new ImportEdits(leadingDelimiterEdits, declarationAndCommentEdits);
    }

    private ImportEdits preserveStationaryImport(OriginalImportEntry importEntry) {
        return new ImportEdits(Collections.singleton(new RangeMarker(importEntry.leadingDelimiter.getOffset(), importEntry.leadingDelimiter.getLength())), Collections.singleton(new RangeMarker(importEntry.declarationAndComments.getOffset(), importEntry.declarationAndComments.getLength())));
    }

    private String determineNewDelimiter(ImportEntry lastImport, ImportEntry currentImport, Collection<ImportComment> reassignedComments) {
        boolean hasReassignedComments;
        if (lastImport == null) {
            return "";
        }
        boolean bl = hasReassignedComments = !reassignedComments.isEmpty();
        if (!this.needsStandardDelimiter(lastImport, currentImport, hasReassignedComments)) {
            return null;
        }
        int numberOfLineDelimiters = 1;
        Collection<ImportComment> leadingComments = hasReassignedComments ? reassignedComments : (currentImport.isOriginal() ? currentImport.asOriginalImportEntry().comments : Collections.emptyList());
        if (ImportEditor.containsFloatingComment(leadingComments)) {
            numberOfLineDelimiters = 2;
        }
        if (this.importGroupComparator.compare(lastImport.importName, currentImport.importName) != 0) {
            numberOfLineDelimiters = Math.max(numberOfLineDelimiters, this.lineDelimitersBetweenImportGroups);
        }
        String standardDelimiter = this.createDelimiter(numberOfLineDelimiters);
        if (currentImport.isOriginal() && !hasReassignedComments) {
            OriginalImportEntry originalImport = currentImport.asOriginalImportEntry();
            IRegion originalDelimiter = originalImport.leadingDelimiter;
            if (originalImport.precedingLineDelimiters == numberOfLineDelimiters) {
                boolean delimiterIsSameLength;
                boolean bl2 = delimiterIsSameLength = originalDelimiter == null && standardDelimiter.isEmpty() || originalDelimiter != null && originalDelimiter.getLength() == standardDelimiter.length();
                if (delimiterIsSameLength) {
                    return null;
                }
            }
        }
        return standardDelimiter;
    }

    private boolean needsStandardDelimiter(ImportEntry lastImport, ImportEntry currentImport, boolean hasReassignedComments) {
        boolean needsStandardDelimiter = false;
        if (this.fixAllLineDelimiters) {
            needsStandardDelimiter = true;
        } else if (!currentImport.isOriginal()) {
            needsStandardDelimiter = true;
        } else if (hasReassignedComments) {
            needsStandardDelimiter = true;
        } else {
            ImportEntry originalPrecedingImport = this.originalPrecedingImports.get(currentImport.importName);
            if (originalPrecedingImport == null || lastImport.importName != originalPrecedingImport.importName) {
                needsStandardDelimiter = true;
            }
        }
        return needsStandardDelimiter;
    }

    private Collection<TextEdit> relocateComments(Collection<ImportComment> reassignedComments, int insertPosition) {
        if (reassignedComments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(reassignedComments.size() * 3);
        ImportComment lastComment = null;
        for (ImportComment currentComment : reassignedComments) {
            MoveSourceEdit sourceEdit = new MoveSourceEdit(currentComment.region.getOffset(), currentComment.region.getLength());
            edits.add(sourceEdit);
            if (lastComment != null) {
                int succeedingLineDelimiters = lastComment.succeedingLineDelimiters > 1 ? 2 : 1;
                edits.add(new InsertEdit(insertPosition, this.createDelimiter(succeedingLineDelimiters)));
            }
            edits.add(new MoveTargetEdit(insertPosition, sourceEdit));
            lastComment = currentComment;
        }
        return edits;
    }

    private static Collection<TextEdit> deleteRemainingText(IRegion importRegion, Collection<TextEdit> edits) {
        ArrayList<TextEdit> sortedEdits = new ArrayList<TextEdit>(edits);
        Collections.sort(sortedEdits, new Comparator<TextEdit>(){

            @Override
            public int compare(TextEdit o1, TextEdit o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
        int deletePosition = importRegion.getOffset();
        ArrayList<TextEdit> deleteRemainingTextEdits = new ArrayList<TextEdit>();
        for (TextEdit edit : sortedEdits) {
            if (edit.getOffset() > deletePosition) {
                deleteRemainingTextEdits.add(new DeleteEdit(deletePosition, edit.getOffset() - deletePosition));
            }
            int editEndPosition = edit.getOffset() + edit.getLength();
            deletePosition = Math.max(deletePosition, editEndPosition);
        }
        int importRegionEndPosition = importRegion.getOffset() + importRegion.getLength();
        if (deletePosition < importRegionEndPosition) {
            deleteRemainingTextEdits.add(new DeleteEdit(deletePosition, importRegionEndPosition - deletePosition));
        }
        return deleteRemainingTextEdits;
    }

    private static final class ImportEdits {
        final Collection<TextEdit> leadingDelimiterEdits;
        final Collection<TextEdit> commentAndDeclarationEdits;

        ImportEdits(Collection<TextEdit> leadingDelimiterEdits, Collection<TextEdit> commentAndDeclarationEdits) {
            this.leadingDelimiterEdits = leadingDelimiterEdits;
            this.commentAndDeclarationEdits = commentAndDeclarationEdits;
        }
    }

    private static final class OriginalImportsCursor {
        private final Iterator<OriginalImportEntry> originalImportIterator;
        OriginalImportEntry currentOriginalImport;
        int currentPosition;

        OriginalImportsCursor(int startPosition, Collection<OriginalImportEntry> originalImportEntries) {
            this.originalImportIterator = originalImportEntries.iterator();
            this.currentPosition = startPosition;
            this.currentOriginalImport = this.originalImportIterator.hasNext() ? this.originalImportIterator.next() : null;
        }

        void advance() {
            IRegion declarationAndComments = this.currentOriginalImport.declarationAndComments;
            this.currentPosition = declarationAndComments.getOffset() + declarationAndComments.getLength();
            this.currentOriginalImport = this.originalImportIterator.hasNext() ? this.originalImportIterator.next() : null;
        }
    }
}

