/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.ImportName;
import org.greenrobot.eclipse.jdt.internal.core.dom.rewrite.imports.OnDemandReduction;

class OnDemandComputer {
    private int typeOnDemandThreshold;
    private int staticOnDemandThreshold;

    OnDemandComputer(int typeOnDemandThreshold, int staticOnDemandThreshold) {
        this.typeOnDemandThreshold = typeOnDemandThreshold;
        this.staticOnDemandThreshold = staticOnDemandThreshold;
    }

    Collection<OnDemandReduction> identifyPossibleReductions(Set<ImportName> imports, Set<ImportName> touchedContainers, Set<String> typeExplicitSimpleNames, Set<String> staticExplicitSimpleNames) {
        ArrayList<OnDemandReduction> candidates = new ArrayList<OnDemandReduction>();
        Map<ImportName, Collection<ImportName>> importsByContainer = this.mapByContainer(imports);
        for (Map.Entry<ImportName, Collection<ImportName>> containerAndImports : importsByContainer.entrySet()) {
            Set<String> explicitSimpleNames;
            int onDemandThreshold;
            Collection<ImportName> containerImports;
            OnDemandReduction candidate;
            ImportName containerOnDemand = containerAndImports.getKey();
            boolean isUnnamedPackage = containerOnDemand.containerName.isEmpty();
            if (!touchedContainers.contains(containerOnDemand) || isUnnamedPackage || (candidate = this.maybeReduce(containerOnDemand, containerImports = containerAndImports.getValue(), onDemandThreshold = containerOnDemand.isStatic ? this.staticOnDemandThreshold : this.typeOnDemandThreshold, explicitSimpleNames = containerOnDemand.isStatic ? staticExplicitSimpleNames : typeExplicitSimpleNames)) == null) continue;
            candidates.add(candidate);
        }
        return candidates;
    }

    private Map<ImportName, Collection<ImportName>> mapByContainer(Collection<ImportName> imports) {
        HashMap<ImportName, Collection<ImportName>> importsByContainer = new HashMap<ImportName, Collection<ImportName>>();
        for (ImportName importName : imports) {
            ImportName containerOnDemand = importName.getContainerOnDemand();
            ArrayList<ImportName> containerImports = (ArrayList<ImportName>)importsByContainer.get(containerOnDemand);
            if (containerImports == null) {
                containerImports = new ArrayList<ImportName>();
                importsByContainer.put(containerOnDemand, containerImports);
            }
            containerImports.add(importName);
        }
        return importsByContainer;
    }

    private OnDemandReduction maybeReduce(ImportName containerOnDemand, Collection<ImportName> containerImports, int onDemandThreshold, Set<String> explicitSimpleNames) {
        boolean containerHasOnDemand = false;
        ArrayList<ImportName> reducibleImports = new ArrayList<ImportName>();
        for (ImportName currentImport : containerImports) {
            if (currentImport.isOnDemand()) {
                containerHasOnDemand = true;
                continue;
            }
            if (explicitSimpleNames.contains(currentImport.simpleName)) continue;
            reducibleImports.add(currentImport);
        }
        if (containerHasOnDemand || reducibleImports.size() >= onDemandThreshold) {
            return new OnDemandReduction(containerOnDemand, reducibleImports);
        }
        return null;
    }
}

