/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd;

import org.greenrobot.eclipse.jdt.internal.core.nd.Nd;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IndexException;

public class NdRawLinkedList {
    private static final int NEXT_MEMBER_BLOCK = 0;
    private static final int ELEMENT_START_POSITION = 4;
    private final long address;
    private final Nd nd;
    private final int firstBlockRecordCount;
    private final int recordCount;
    private final int elementRecordSize;
    private final int metadataBitsPerRecord;
    private long lastKnownBlock;

    public NdRawLinkedList(Nd nd, long address, int elementRecordSize, int firstBlockRecordCount, int recordsPerBlock, int metadataBitsPerRecord) {
        assert (recordsPerBlock > 0);
        assert (firstBlockRecordCount >= 0);
        this.nd = nd;
        this.address = address;
        this.firstBlockRecordCount = firstBlockRecordCount;
        this.recordCount = recordsPerBlock;
        this.elementRecordSize = elementRecordSize;
        this.lastKnownBlock = address;
        this.metadataBitsPerRecord = metadataBitsPerRecord;
    }

    public static int recordSize(int elementRecordSize, int recordsPerBlock, int metadataBitsPerRecord) {
        int metadataSize = 0;
        if (metadataBitsPerRecord > 0) {
            int metadataRecordsPerShort = 16 / metadataBitsPerRecord;
            int numberOfShorts = (recordsPerBlock + metadataRecordsPerShort - 1) / metadataRecordsPerShort;
            metadataSize = 2 * numberOfShorts;
        }
        return 4 + elementRecordSize * recordsPerBlock + metadataSize;
    }

    public Nd getNd() {
        return this.nd;
    }

    private int getElementsInBlock(long currentRecord, long ptr, int currentRecordCount) throws IndexException {
        if (ptr == 0L && currentRecordCount > 0) {
            return this.getDB().getInt(this.getAddressOfElement(currentRecord, currentRecordCount - 1));
        }
        return currentRecordCount;
    }

    private Database getDB() {
        return this.nd.getDB();
    }

    public long getAddress() {
        return this.address;
    }

    public long addMember(short metadataBits) throws IndexException {
        Database db = this.getDB();
        long current = this.lastKnownBlock;
        int thisBlockRecordCount = this.firstBlockRecordCount;
        while (true) {
            long ptr;
            int elementsInBlock;
            if ((elementsInBlock = this.getElementsInBlock(current, ptr = db.getRecPtr(current + 0L), thisBlockRecordCount)) < thisBlockRecordCount) {
                long positionOfElementCount = this.getAddressOfElement(current, thisBlockRecordCount - 1);
                if (elementsInBlock == thisBlockRecordCount - 1) {
                    db.putRecPtr(current + 0L, current);
                    db.putInt(positionOfElementCount, 0);
                } else {
                    db.putInt(positionOfElementCount, elementsInBlock + 1);
                }
                if (this.metadataBitsPerRecord > 0) {
                    int metadataMask = (1 << this.metadataBitsPerRecord) - 1;
                    int metadataRecordsPerShort = this.metadataBitsPerRecord == 0 ? 0 : 16 / this.metadataBitsPerRecord;
                    metadataBits = (short)(metadataBits & metadataMask);
                    int metadataBitOffset = elementsInBlock % metadataRecordsPerShort;
                    long metadataStart = this.getAddressOfMetadata(current, thisBlockRecordCount);
                    int whichShort = elementsInBlock / metadataRecordsPerShort;
                    long metadataOffset = metadataStart + (long)(2 * whichShort);
                    short metadataValue = db.getShort(metadataOffset);
                    metadataValue = (short)(metadataValue & ~(metadataMask << metadataBitOffset * this.metadataBitsPerRecord));
                    metadataValue = (short)(metadataValue | metadataBits << metadataBitOffset * this.metadataBitsPerRecord);
                    this.getDB().putShort(metadataOffset, metadataValue);
                }
                this.lastKnownBlock = current;
                return this.getAddressOfElement(current, elementsInBlock);
            }
            if (this.isLastBlock(current, ptr)) {
                current = db.malloc(NdRawLinkedList.recordSize(this.elementRecordSize, this.recordCount, this.metadataBitsPerRecord), (short)5);
                db.putRecPtr(current + 0L, current);
                continue;
            }
            thisBlockRecordCount = this.recordCount;
            current = ptr;
        }
    }

    private long getAddressOfElement(long blockRecordStart, int elementNumber) {
        return blockRecordStart + 4L + (long)(elementNumber * this.elementRecordSize);
    }

    private long getAddressOfMetadata(long blockRecordStart, int blockRecordCount) {
        return this.getAddressOfElement(blockRecordStart, blockRecordCount);
    }

    public void accept(ILinkedListVisitor visitor) throws IndexException {
        int count = 0;
        Database db = this.getDB();
        int blockRecordCount = this.firstBlockRecordCount;
        int metadataMask = (1 << this.metadataBitsPerRecord) - 1;
        int metadataRecordsPerShort = this.metadataBitsPerRecord == 0 ? 0 : 16 / this.metadataBitsPerRecord;
        long current = this.address;
        while (true) {
            long ptr = db.getRecPtr(current + 0L);
            int elementsInBlock = this.getElementsInBlock(current, ptr, blockRecordCount);
            long metadataStart = this.getAddressOfMetadata(current, blockRecordCount);
            int idx = 0;
            while (idx < elementsInBlock) {
                long elementRecord = this.getAddressOfElement(current, idx);
                short metadataBits = 0;
                if (metadataRecordsPerShort > 0) {
                    int metadataBitOffset = idx % metadataRecordsPerShort;
                    int whichShort = idx / metadataRecordsPerShort;
                    long metadataOffset = metadataStart + (long)(2 * whichShort);
                    metadataBits = this.getDB().getShort(metadataOffset);
                    metadataBits = (short)(metadataBits >>> metadataBits * metadataBitOffset);
                    metadataBits = (short)(metadataBits & metadataMask);
                }
                visitor.visit(elementRecord, metadataBits, count++);
                ++idx;
            }
            blockRecordCount = this.recordCount;
            if (this.isLastBlock(current, ptr)) {
                return;
            }
            current = ptr;
        }
    }

    public void destruct() throws IndexException {
        Database db = this.getDB();
        long current = this.address;
        while (true) {
            long ptr = db.getRecPtr(current + 0L);
            db.free(current, (short)5);
            if (this.isLastBlock(current, ptr)) {
                return;
            }
            current = ptr;
        }
    }

    private boolean isLastBlock(long blockAddress, long pointerToNextBlock) {
        return pointerToNextBlock == 0L || pointerToNextBlock == blockAddress;
    }

    public int size() throws IndexException {
        int count = 0;
        Database db = this.getDB();
        int currentRecordCount = this.firstBlockRecordCount;
        long current = this.address;
        while (true) {
            long ptr = db.getRecPtr(current + 0L);
            count += this.getElementsInBlock(current, ptr, currentRecordCount);
            if (this.isLastBlock(current, ptr)) break;
            currentRecordCount = this.recordCount;
            current = ptr;
        }
        return count;
    }

    public static interface ILinkedListVisitor {
        public void visit(long var1, short var3, int var4) throws IndexException;
    }
}

