/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.java;

import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.IWorkspaceRoot;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.jdt.internal.core.nd.Nd;
import org.greenrobot.eclipse.jdt.internal.core.nd.NdNode;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IString;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IndexException;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldList;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldLong;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldSearchKey;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldString;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.StructDef;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.FileFingerprint;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.NdType;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.NdWorkspaceLocation;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.NdZipEntry;

public class NdResourceFile
extends NdNode {
    public static final FieldSearchKey<JavaIndex> FILENAME;
    public static final FieldOneToMany<NdType> TYPES;
    public static final FieldLong TIME_LAST_USED;
    public static final FieldLong TIME_LAST_SCANNED;
    public static final FieldLong SIZE_LAST_SCANNED;
    public static final FieldLong HASHCODE_LAST_SCANNED;
    public static final FieldOneToMany<NdWorkspaceLocation> WORKSPACE_MAPPINGS;
    public static final FieldString JAVA_ROOT;
    public static final FieldLong JDK_LEVEL;
    public static final FieldList<NdZipEntry> ZIP_ENTRIES;
    public static final FieldString MANIFEST_CONTENT;
    public static final FieldShort FILE_FLAGS;
    public static final int FLG_CORRUPT_ZIP_FILE = 1;
    public static final StructDef<NdResourceFile> type;
    private long jdkLevel;

    static {
        type = StructDef.create(NdResourceFile.class, NdNode.type);
        FILENAME = FieldSearchKey.create(type, JavaIndex.FILES);
        TYPES = FieldOneToMany.create(type, NdType.FILE, 16);
        TIME_LAST_USED = type.addLong();
        TIME_LAST_SCANNED = type.addLong();
        SIZE_LAST_SCANNED = type.addLong();
        HASHCODE_LAST_SCANNED = type.addLong();
        WORKSPACE_MAPPINGS = FieldOneToMany.create(type, NdWorkspaceLocation.RESOURCE);
        JAVA_ROOT = type.addString();
        JDK_LEVEL = type.addLong();
        ZIP_ENTRIES = FieldList.create(type, NdZipEntry.type, 1);
        MANIFEST_CONTENT = type.addString();
        FILE_FLAGS = type.addShort();
        type.done();
    }

    public NdResourceFile(Nd dom, long address) {
        super(dom, address);
    }

    public NdResourceFile(Nd nd) {
        super(nd);
    }

    public boolean isCorruptedZipFile() {
        return this.hasAllFlags(1);
    }

    public int getFlags() {
        return FILE_FLAGS.get(this.getNd(), this.address);
    }

    public boolean hasAllFlags(int flags) {
        int ourFlags = this.getFlags();
        return (ourFlags & flags) == flags;
    }

    public void setFlags(int flags) {
        FILE_FLAGS.put(this.getNd(), this.address, (short)(this.getFlags() | flags));
    }

    public List<NdZipEntry> getZipEntries() {
        return ZIP_ENTRIES.asList(this.getNd(), this.getAddress());
    }

    public IString getManifestContent() {
        return MANIFEST_CONTENT.get(this.getNd(), this.getAddress());
    }

    public void setManifestContent(char[] newContent) {
        MANIFEST_CONTENT.put(this.getNd(), this.getAddress(), newContent);
    }

    public long getJdkLevel() {
        if (this.jdkLevel == 0L) {
            this.jdkLevel = JDK_LEVEL.get(this.getNd(), this.address);
        }
        return this.jdkLevel;
    }

    public void setJdkLevel(long jdkLevel) {
        if (this.getJdkLevel() != jdkLevel) {
            JDK_LEVEL.put(this.getNd(), this.address, jdkLevel);
        }
    }

    public boolean isInIndex() {
        block3: {
            try {
                if (this.nd.isValidAddress(this.address) && NODE_TYPE.get(this.nd, this.address) == this.nd.getNodeType(this.getClass())) break block3;
                return false;
            }
            catch (IndexException indexException) {
                return false;
            }
        }
        char[] filename = FILENAME.get(this.getNd(), this.address).getChars();
        NdResourceFile result = JavaIndex.FILES.findBest(this.nd, Database.DATA_AREA_OFFSET, FieldSearchIndex.SearchCriteria.create(filename), new FieldSearchIndex.IResultRank(){

            @Override
            public long getRank(Nd testNd, long testAddress) {
                if (testAddress == NdResourceFile.this.address) {
                    return 1L;
                }
                return -1L;
            }
        });
        return this.equals(result);
    }

    public List<IPath> getAllWorkspaceLocations() {
        final ArrayList<IPath> result = new ArrayList<IPath>();
        WORKSPACE_MAPPINGS.accept(this.getNd(), this.address, new FieldOneToMany.Visitor<NdWorkspaceLocation>(){

            @Override
            public void visit(int index, NdWorkspaceLocation toVisit) {
                result.add(new Path(toVisit.getPath().getString()));
            }
        });
        return result;
    }

    public IPath getFirstWorkspaceLocation() {
        if (WORKSPACE_MAPPINGS.isEmpty(this.getNd(), this.address)) {
            return Path.EMPTY;
        }
        return new Path(WORKSPACE_MAPPINGS.get(this.getNd(), this.address, 0).getPath().toString());
    }

    public IPath getAnyOpenWorkspaceLocation(IWorkspaceRoot root) {
        int numMappings = WORKSPACE_MAPPINGS.size(this.getNd(), this.address);
        int mapping = 0;
        while (mapping < numMappings) {
            IProject project;
            NdWorkspaceLocation nextMapping = WORKSPACE_MAPPINGS.get(this.getNd(), this.address, mapping);
            Path nextPath = new Path(nextMapping.getPath().getString());
            if (!nextPath.isEmpty() && (project = root.getProject(nextPath.segment(0))).isOpen()) {
                return nextPath;
            }
            ++mapping;
        }
        return Path.EMPTY;
    }

    public IPath getPath() {
        IPath workspacePath = this.getFirstWorkspaceLocation();
        if (workspacePath.isEmpty()) {
            return new Path(this.getLocation().getString());
        }
        return workspacePath;
    }

    public List<NdWorkspaceLocation> getWorkspaceMappings() {
        return WORKSPACE_MAPPINGS.asList(this.getNd(), this.address);
    }

    public IString getLocation() {
        return FILENAME.get(this.getNd(), this.address);
    }

    public void setLocation(String filename) {
        FILENAME.put(this.getNd(), this.address, filename);
    }

    public FileFingerprint getFingerprint() {
        return new FileFingerprint(this.getTimeLastScanned(), this.getSizeLastScanned(), this.getHashcodeLastScanned());
    }

    private long getHashcodeLastScanned() {
        return HASHCODE_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public boolean isDoneIndexing() {
        return this.getTimeLastScanned() != 0L;
    }

    public long getTimeLastScanned() {
        return TIME_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public long getSizeLastScanned() {
        return SIZE_LAST_SCANNED.get(this.getNd(), this.address);
    }

    public long getTimeLastUsed() {
        return TIME_LAST_USED.get(this.getNd(), this.address);
    }

    public void setTimeLastUsed(long timeLastUsed) {
        TIME_LAST_USED.put(this.getNd(), this.address, timeLastUsed);
    }

    public void setFingerprint(FileFingerprint newFingerprint) {
        TIME_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getTime());
        HASHCODE_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getHash());
        SIZE_LAST_SCANNED.put(this.getNd(), this.address, newFingerprint.getSize());
    }

    public void setPackageFragmentRoot(char[] javaRoot) {
        JAVA_ROOT.put(this.getNd(), this.address, javaRoot);
    }

    public IString getPackageFragmentRoot() {
        IString javaRoot = JAVA_ROOT.get(this.getNd(), this.address);
        if (javaRoot.length() == 0) {
            return this.getLocation();
        }
        return javaRoot;
    }

    public void markAsInvalid() {
        TIME_LAST_SCANNED.put(this.getNd(), this.address, 0L);
    }

    public int getTypeCount() {
        return TYPES.size(this.getNd(), this.address);
    }

    public List<NdType> getTypes() {
        return TYPES.asList(this.getNd(), this.address);
    }

    public NdType getType(int index) {
        return TYPES.get(this.getNd(), this.address, index);
    }

    public String toString() {
        try {
            return FILENAME.get(this.getNd(), this.address).toString();
        }
        catch (RuntimeException runtimeException) {
            return super.toString();
        }
    }

    public void allocateZipEntries(int expectedNumberOfZipEntries) {
        ZIP_ENTRIES.allocate(this.nd, this.address, expectedNumberOfZipEntries);
    }

    public NdZipEntry addZipEntry(String fileName) {
        NdZipEntry result = ZIP_ENTRIES.append(this.getNd(), this.getAddress());
        result.setFilename(fileName);
        return result;
    }
}

