/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.util;

import org.greenrobot.eclipse.jdt.core.IInitializer;
import org.greenrobot.eclipse.jdt.core.ILocalVariable;
import org.greenrobot.eclipse.jdt.core.IMember;
import org.greenrobot.eclipse.jdt.core.ISourceRange;
import org.greenrobot.eclipse.jdt.core.ITypeParameter;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.core.dom.ASTNode;
import org.greenrobot.eclipse.jdt.core.dom.ASTVisitor;
import org.greenrobot.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.greenrobot.eclipse.jdt.core.dom.CompilationUnit;
import org.greenrobot.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.EnumDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.IBinding;
import org.greenrobot.eclipse.jdt.core.dom.ImportDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.Initializer;
import org.greenrobot.eclipse.jdt.core.dom.MarkerAnnotation;
import org.greenrobot.eclipse.jdt.core.dom.MethodDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.ModuleDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.NormalAnnotation;
import org.greenrobot.eclipse.jdt.core.dom.PackageDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.ParameterizedType;
import org.greenrobot.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.greenrobot.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.TypeDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.TypeParameter;
import org.greenrobot.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.greenrobot.eclipse.jdt.internal.core.LambdaExpression;
import org.greenrobot.eclipse.jdt.internal.core.LambdaMethod;
import org.greenrobot.eclipse.jdt.internal.core.SourceRefElement;

public class DOMFinder
extends ASTVisitor {
    public ASTNode foundNode = null;
    public IBinding foundBinding = null;
    private CompilationUnit ast;
    private SourceRefElement element;
    private boolean resolveBinding;
    private int rangeStart = -1;
    private int rangeLength = 0;

    public DOMFinder(CompilationUnit ast, SourceRefElement element, boolean resolveBinding) {
        this.ast = ast;
        this.element = element;
        this.resolveBinding = resolveBinding;
    }

    protected boolean found(ASTNode node, ASTNode name) {
        if (name.getStartPosition() == this.rangeStart && name.getLength() == this.rangeLength) {
            this.foundNode = node;
            return true;
        }
        return false;
    }

    public ASTNode search() throws JavaModelException {
        ISourceRange range = null;
        range = this.element instanceof IMember && !(this.element instanceof IInitializer) && !(this.element instanceof LambdaMethod) && !(this.element instanceof LambdaExpression) ? ((IMember)((Object)this.element)).getNameRange() : (this.element instanceof ITypeParameter || this.element instanceof ILocalVariable ? this.element.getNameRange() : this.element.getSourceRange());
        this.rangeStart = range.getOffset();
        this.rangeLength = range.getLength();
        this.ast.accept(this);
        return this.foundNode;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        ASTNode name;
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 14: {
                name = ((ClassInstanceCreation)parent).getType();
                if (name.getNodeType() != 74) break;
                name = ((ParameterizedType)name).getType();
                break;
            }
            case 72: {
                name = ((EnumConstantDeclaration)parent).getName();
                break;
            }
            default: {
                return true;
            }
        }
        if (this.found(node, name) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveVariable();
        }
        return true;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(Initializer node) {
        this.found(node, node);
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(TypeParameter node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(org.greenrobot.eclipse.jdt.core.dom.LambdaExpression node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveMethodBinding();
        }
        return true;
    }
}

