/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jface.text.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.jface.text.DocumentEvent;
import org.greenrobot.eclipse.jface.text.IDocument;
import org.greenrobot.eclipse.jface.text.IDocumentInformationMapping;
import org.greenrobot.eclipse.jface.text.IDocumentListener;
import org.greenrobot.eclipse.jface.text.ISlaveDocumentManager;
import org.greenrobot.eclipse.jface.text.ISlaveDocumentManagerExtension;
import org.greenrobot.eclipse.jface.text.projection.ProjectionDocument;

public class ProjectionDocumentManager
implements IDocumentListener,
ISlaveDocumentManager,
ISlaveDocumentManagerExtension {
    private Map<IDocument, List<ProjectionDocument>> fProjectionRegistry = new HashMap<IDocument, List<ProjectionDocument>>();

    private void add(IDocument master, ProjectionDocument projection) {
        List<ProjectionDocument> list = this.fProjectionRegistry.get(master);
        if (list == null) {
            list = new ArrayList<ProjectionDocument>(1);
            this.fProjectionRegistry.put(master, list);
        }
        list.add(projection);
    }

    private void remove(IDocument master, ProjectionDocument projection) {
        List<ProjectionDocument> list = this.fProjectionRegistry.get(master);
        if (list != null) {
            list.remove(projection);
            if (list.isEmpty()) {
                this.fProjectionRegistry.remove(master);
            }
        }
    }

    private boolean hasProjection(IDocument master) {
        return this.fProjectionRegistry.get(master) != null;
    }

    private Iterator<ProjectionDocument> getProjectionsIterator(IDocument master) {
        List<ProjectionDocument> list = this.fProjectionRegistry.get(master);
        if (list != null) {
            return list.iterator();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void fireDocumentEvent(boolean about, DocumentEvent masterEvent) {
        master = masterEvent.getDocument();
        e = this.getProjectionsIterator(master);
        if (e != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            document = e.next();
            if (about) {
                document.masterDocumentAboutToBeChanged(masterEvent);
                continue;
            }
            document.masterDocumentChanged(masterEvent);
lbl10:
            // 3 sources

            ** while (e.hasNext())
        }
lbl11:
        // 1 sources

    }

    @Override
    public void documentChanged(DocumentEvent event) {
        this.fireDocumentEvent(false, event);
    }

    @Override
    public void documentAboutToBeChanged(DocumentEvent event) {
        this.fireDocumentEvent(true, event);
    }

    @Override
    public IDocumentInformationMapping createMasterSlaveMapping(IDocument slave) {
        if (slave instanceof ProjectionDocument) {
            ProjectionDocument projectionDocument = (ProjectionDocument)slave;
            return projectionDocument.getDocumentInformationMapping();
        }
        return null;
    }

    @Override
    public IDocument createSlaveDocument(IDocument master) {
        if (!this.hasProjection(master)) {
            master.addDocumentListener(this);
        }
        ProjectionDocument slave = this.createProjectionDocument(master);
        this.add(master, slave);
        return slave;
    }

    protected ProjectionDocument createProjectionDocument(IDocument master) {
        return new ProjectionDocument(master);
    }

    @Override
    public void freeSlaveDocument(IDocument slave) {
        if (slave instanceof ProjectionDocument) {
            ProjectionDocument projectionDocument = (ProjectionDocument)slave;
            IDocument master = projectionDocument.getMasterDocument();
            this.remove(master, projectionDocument);
            projectionDocument.dispose();
            if (!this.hasProjection(master)) {
                master.removeDocumentListener(this);
            }
        }
    }

    @Override
    public IDocument getMasterDocument(IDocument slave) {
        if (slave instanceof ProjectionDocument) {
            return ((ProjectionDocument)slave).getMasterDocument();
        }
        return null;
    }

    @Override
    public boolean isSlaveDocument(IDocument document) {
        return document instanceof ProjectionDocument;
    }

    @Override
    public void setAutoExpandMode(IDocument slave, boolean autoExpanding) {
        if (slave instanceof ProjectionDocument) {
            ((ProjectionDocument)slave).setAutoExpandMode(autoExpanding);
        }
    }

    @Override
    public IDocument[] getSlaveDocuments(IDocument master) {
        List<ProjectionDocument> list = this.fProjectionRegistry.get(master);
        if (list != null) {
            IDocument[] result = new IDocument[list.size()];
            list.toArray(result);
            return result;
        }
        return null;
    }
}

