/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.framework.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadInfoReport
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public ThreadInfoReport(String failedMonitor) {
        super(ThreadInfoReport.getThreadDump(failedMonitor));
    }

    public static String getThreadDump(String failedMonitor) {
        ThreadInfo[] infos;
        long currentId = Thread.currentThread().getId();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        StringBuilder dump = new StringBuilder("Thread dump");
        ThreadInfo[] threadInfoArray = infos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            ThreadInfoReport.dumpThreadIDNameState(info, dump);
            ThreadInfoReport.dumpLockInfo(currentId, failedMonitor, info, dump);
            ThreadInfoReport.dumpStackTrace(info, dump);
            ++n2;
        }
        return dump.toString();
    }

    private static void dumpThreadIDNameState(ThreadInfo info, StringBuilder dump) {
        dump.append('\n').append('\n');
        dump.append("ThreadId: ").append(info.getThreadId());
        dump.append(" ThreadName: ").append(info.getThreadName());
        dump.append(" ThreadState: ").append((Object)info.getThreadState());
    }

    private static void dumpLockInfo(long currentId, String failedMonitor, ThreadInfo info, StringBuilder dump) {
        int n;
        dump.append('\n');
        dump.append("  Blocked On: ");
        LockInfo blockedOn = info.getLockInfo();
        if (blockedOn == null) {
            if (currentId == info.getThreadId() && failedMonitor != null) {
                dump.append(failedMonitor);
            } else {
                dump.append("none");
            }
        } else {
            dump.append(blockedOn.toString());
            dump.append(" LockOwnerId: ").append(info.getLockOwnerId());
            dump.append(" LockOwnerName: ").append(info.getLockOwnerName());
        }
        dump.append('\n');
        dump.append("  Synchronizers Locked: ");
        LockInfo[] synchronizers = info.getLockedSynchronizers();
        if (synchronizers.length == 0) {
            dump.append("none");
        } else {
            LockInfo[] lockInfoArray = synchronizers;
            n = synchronizers.length;
            int n2 = 0;
            while (n2 < n) {
                LockInfo sync = lockInfoArray[n2];
                dump.append('\n');
                dump.append("    ").append(sync.toString());
                ++n2;
            }
        }
        dump.append('\n');
        dump.append("  Monitors Locked: ");
        MonitorInfo[] monitors = info.getLockedMonitors();
        if (monitors.length == 0) {
            dump.append("none");
        }
        MonitorInfo[] monitorInfoArray = monitors;
        int n3 = monitors.length;
        n = 0;
        while (n < n3) {
            MonitorInfo monitor = monitorInfoArray[n];
            dump.append('\n');
            dump.append("    ").append(monitor.toString());
            ++n;
        }
        dump.append('\n');
    }

    private static void dumpStackTrace(ThreadInfo info, StringBuilder dump) {
        dump.append("  Stack Trace: ");
        StackTraceElement[] stackTraceElementArray = info.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            dump.append('\n').append("    ").append(e);
            ++n2;
        }
    }
}

