/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eclipse.osgi.internal.debug.Debug;
import org.greenrobot.eclipse.osgi.internal.util.Tokenizer;

public class AliasMapper {
    private static final Map<String, Collection<String>> processorAliasTable = new HashMap<String, Collection<String>>();
    private static final Map<String, String> processorCanonicalTable = new HashMap<String, String>();
    private static final Map<String, Collection<String>> osnameAliasTable = new HashMap<String, Collection<String>>();
    private static final Map<String, String> osnameCanonicalTable = new HashMap<String, String>();

    static {
        AliasMapper.getTables("osname.aliases", osnameAliasTable, osnameCanonicalTable);
        AliasMapper.getTables("processor.aliases", processorAliasTable, processorCanonicalTable);
    }

    private static void getTables(String resourceName, Map<String, Collection<String>> aliasTable, Map<String, String> canonicalTable) {
        InputStream in = AliasMapper.class.getResourceAsStream(resourceName);
        if (in != null) {
            try {
                AliasMapper.initAliases(in, aliasTable, canonicalTable);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Collection<String> getProcessorAliases(String processor) {
        return this.getAlias(processor.toLowerCase(), processorAliasTable);
    }

    public Collection<String> getOSNameAliases(String osname) {
        return this.getAlias(osname.toLowerCase(), osnameAliasTable);
    }

    public String getCanonicalOSName(String osname) {
        String lowerName = osname.toLowerCase();
        String result = osnameCanonicalTable.get(lowerName);
        if (result == null && lowerName.startsWith("windows")) {
            return "win32";
        }
        return result == null ? osname : result;
    }

    public String getCanonicalProcessor(String processor) {
        String result = processorCanonicalTable.get(processor.toLowerCase());
        return result == null ? processor : result;
    }

    private Collection<String> getAlias(String name, Map<String, Collection<String>> aliasMap) {
        Collection<String> aliases;
        if (name == null) {
            return Collections.emptyList();
        }
        Collection<String> collection = aliases = aliasMap == null ? null : aliasMap.get(name);
        if (aliases != null) {
            return Collections.unmodifiableCollection(aliases);
        }
        return Collections.singletonList(name.toLowerCase());
    }

    private static Map<String, Collection<String>> initAliases(InputStream in, Map<String, Collection<String>> aliasTable, Map<String, String> canonicalTable) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            HashMap<String, HashSet<String>> multiMaster = new HashMap<String, HashSet<String>>();
            while ((line = br.readLine()) != null) {
                String alias;
                Tokenizer tokenizer = new Tokenizer(line);
                String master = tokenizer.getString("# \t");
                if (master == null) continue;
                String masterLower = master.toLowerCase();
                canonicalTable.put(masterLower, master);
                ArrayList<String> aliasLine = new ArrayList<String>(1);
                aliasLine.add(master);
                while ((alias = tokenizer.getString("# \t")) != null) {
                    aliasLine.add(alias);
                    String aliasLower = alias.toLowerCase();
                    if (!canonicalTable.containsKey(aliasLower)) {
                        canonicalTable.put(aliasLower, master);
                        continue;
                    }
                    String existingMaster = canonicalTable.put(aliasLower, alias);
                    HashSet<String> masters = (HashSet<String>)multiMaster.get(aliasLower);
                    if (masters == null) {
                        masters = new HashSet<String>();
                        multiMaster.put(aliasLower, masters);
                        masters.add(existingMaster.toLowerCase());
                    }
                    masters.add(masterLower);
                }
                aliasTable.put(masterLower, aliasLine);
            }
            HashMap multiMasterAliases = new HashMap(multiMaster.size());
            for (Map.Entry entry : multiMaster.entrySet()) {
                HashSet<String> aliases = new HashSet<String>();
                for (String master : (Set)entry.getValue()) {
                    aliases.addAll(aliasTable.get(master));
                }
                multiMasterAliases.put((String)entry.getKey(), aliases);
            }
            aliasTable.putAll(multiMasterAliases);
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
        return aliasTable;
    }
}

