/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.greenrobot.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.Version;
import org.greenrobot.osgi.service.log.admin.LoggerContext;

public class LoggerContextTargetMap {
    private final Map<Bundle, ExtendedLogServiceImpl> logServices = new HashMap<Bundle, ExtendedLogServiceImpl>();
    private final Map<String, ExtendedLogServiceFactory.EquinoxLoggerContext> loggerContexts = new HashMap<String, ExtendedLogServiceFactory.EquinoxLoggerContext>();
    private final Map<Bundle, List<String>> targetToQualifiedNames = new HashMap<Bundle, List<String>>();
    private final Map<String, Collection<Bundle>> qualifiedNameToTargets = new HashMap<String, Collection<Bundle>>();

    List<String> add(Bundle b) {
        Version v;
        String bsn = b.getSymbolicName();
        if (bsn == null) {
            bsn = "";
        }
        String version = (v = b.getVersion()) == null ? "" : v.toString();
        String location = ExtendedLogServiceFactory.secureAction.getLocation(b);
        ArrayList<String> result = new ArrayList<String>(3);
        StringBuilder sb = new StringBuilder(bsn);
        this.getTargetsInternal(bsn).add(b);
        sb.append('|').append(version);
        String bsnVersion = sb.toString();
        this.getTargetsInternal(bsnVersion).add(b);
        sb.append('|').append(location);
        String bsnVersionLocation = sb.toString();
        this.getTargetsInternal(bsnVersionLocation).add(b);
        result.add(bsnVersionLocation);
        result.add(bsnVersion);
        result.add(bsn);
        List<String> unmodifiable = Collections.unmodifiableList(result);
        this.targetToQualifiedNames.put(b, unmodifiable);
        return unmodifiable;
    }

    void remove(Bundle b) {
        List<String> qualifiedNames = this.targetToQualifiedNames.remove(b);
        if (qualifiedNames != null) {
            for (String qualifiedName : qualifiedNames) {
                Collection<Bundle> targets = this.qualifiedNameToTargets.get(qualifiedName);
                if (targets == null) continue;
                targets.remove(b);
                if (!targets.isEmpty()) continue;
                this.qualifiedNameToTargets.remove(qualifiedName);
            }
        }
        this.logServices.remove(b);
    }

    private Collection<Bundle> getTargetsInternal(String pid) {
        Collection<Bundle> targets = this.qualifiedNameToTargets.get(pid);
        if (targets == null) {
            targets = new ArrayList<Bundle>(1);
            this.qualifiedNameToTargets.put(pid, targets);
        }
        return targets;
    }

    ExtendedLogServiceImpl getLogService(Bundle bundle, ExtendedLogServiceFactory factory) {
        ExtendedLogServiceImpl logService = this.logServices.get(bundle);
        if (logService == null) {
            this.add(bundle);
            logService = new ExtendedLogServiceImpl(factory, bundle);
            if (bundle != null && bundle.getState() != 1) {
                this.logServices.put(bundle, logService);
            }
        }
        return logService;
    }

    void replaceSystemBundleLogService(Bundle previousBundle, Bundle currentBundle) {
        ExtendedLogServiceImpl existing = this.logServices.get(previousBundle);
        if (existing != null) {
            this.remove(previousBundle);
            this.add(currentBundle);
            this.logServices.put(currentBundle, existing);
            existing.applyLogLevels(this.getEffectiveLoggerContext(currentBundle));
        }
    }

    void clear() {
        this.logServices.clear();
        this.qualifiedNameToTargets.clear();
        this.targetToQualifiedNames.clear();
        this.loggerContexts.clear();
    }

    LoggerContext createLoggerContext(String name, ExtendedLogServiceFactory factory) {
        ExtendedLogServiceFactory.EquinoxLoggerContext loggerContext = this.loggerContexts.get(name);
        if (loggerContext == null) {
            loggerContext = factory.createEquinoxLoggerContext(name);
            this.loggerContexts.put(name, loggerContext);
        }
        return loggerContext;
    }

    ExtendedLogServiceFactory.EquinoxLoggerContext getRootLoggerContext() {
        return this.loggerContexts.get(null);
    }

    void applyLogLevels(ExtendedLogServiceFactory.EquinoxLoggerContext loggerContext) {
        boolean isRoot = loggerContext.getName() == null;
        Collection<Bundle> matching = isRoot ? this.logServices.keySet() : this.qualifiedNameToTargets.get(loggerContext.getName());
        if (matching == null) {
            return;
        }
        for (Bundle bundle : matching) {
            ExtendedLogServiceImpl logService = this.logServices.get(bundle);
            if (logService == null) continue;
            logService.applyLogLevels(this.getEffectiveLoggerContext(bundle));
        }
    }

    ExtendedLogServiceFactory.EquinoxLoggerContext getEffectiveLoggerContext(Bundle bundle) {
        List<String> qualifiedNames = this.targetToQualifiedNames.get(bundle);
        if (qualifiedNames != null) {
            for (String qualifiedName : qualifiedNames) {
                ExtendedLogServiceFactory.EquinoxLoggerContext loggerContext = this.loggerContexts.get(qualifiedName);
                if (loggerContext == null || loggerContext.isEmpty()) continue;
                return loggerContext;
            }
        }
        return this.getRootLoggerContext();
    }
}

