/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.serviceregistry;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.osgi.internal.debug.Debug;
import org.greenrobot.eclipse.osgi.internal.framework.BundleContextImpl;
import org.greenrobot.eclipse.osgi.internal.loader.sources.PackageSource;
import org.greenrobot.eclipse.osgi.internal.messages.Msg;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ModifiedServiceEvent;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.PrototypeServiceFactoryUse;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceConsumer;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceFactoryUse;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceObjectsImpl;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceProperties;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.greenrobot.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.PrototypeServiceFactory;
import org.greenrobot.osgi.framework.ServiceEvent;
import org.greenrobot.osgi.framework.ServiceException;
import org.greenrobot.osgi.framework.ServiceFactory;
import org.greenrobot.osgi.framework.ServiceReference;
import org.greenrobot.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl<S>
implements ServiceRegistration<S>,
Comparable<ServiceRegistrationImpl<?>> {
    private final ServiceRegistry registry;
    private final BundleContextImpl context;
    private final Bundle bundle;
    private final String[] clazzes;
    private final S service;
    private ServiceReferenceImpl<S> reference;
    private final List<BundleContextImpl> contextsUsing;
    private Map<String, Object> properties;
    private final long serviceid;
    private int serviceranking;
    private final Object registrationLock = new Object();
    private int state;
    private static final int REGISTERED = 0;
    private static final int UNREGISTERING = 1;
    private static final int UNREGISTERED = 2;
    private static final int FRAMEWORK_SET_SERVICE_PROPERTIES_COUNT = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistrationImpl(ServiceRegistry registry, BundleContextImpl context, String[] clazzes, S service) {
        this.registry = registry;
        this.context = context;
        this.bundle = context.getBundleImpl();
        this.clazzes = clazzes;
        this.service = service;
        this.serviceid = registry.getNextServiceId();
        this.contextsUsing = new ArrayList<BundleContextImpl>(10);
        Object object = this.registrationLock;
        synchronized (object) {
            this.state = 0;
            this.reference = new ServiceReferenceImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Dictionary<String, ?> props) {
        ServiceReferenceImpl<S> ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            this.context.checkValid();
            Object object = this.registrationLock;
            synchronized (object) {
                ref = this.reference;
                this.properties = this.createProperties(props);
            }
            if (this.registry.debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.registry.addServiceRegistration(this.context, this);
        }
        this.registry.publishServiceEvent(new ServiceEvent(1, ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Dictionary<String, ?> props) {
        Map<String, Object> previousProperties;
        ServiceReferenceImpl<S> ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                ref = this.reference;
                previousProperties = this.properties;
                this.properties = this.createProperties(props);
            }
            this.registry.modifyServiceRegistration(this.context, this);
        }
        this.registry.publishServiceEvent(new ModifiedServiceEvent(ref, previousProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        ServiceReferenceImpl<S> ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                if (this.registry.debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
                }
                this.registry.removeServiceRegistration(this.context, this);
                this.state = 1;
                ref = this.reference;
            }
        }
        this.registry.publishServiceEvent(new ServiceEvent(4, ref));
        int size = 0;
        BundleContextImpl[] users = null;
        Object object = this.registrationLock;
        synchronized (object) {
            this.state = 2;
            size = this.contextsUsing.size();
            if (size > 0) {
                if (this.registry.debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService: releasing users");
                }
                users = this.contextsUsing.toArray(new BundleContextImpl[size]);
            }
        }
        int i = 0;
        while (i < size) {
            this.releaseService(users[i]);
            ++i;
        }
        Object object2 = this.registrationLock;
        synchronized (object2) {
            this.contextsUsing.clear();
            this.reference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isUnregistered() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    @Override
    public ServiceReference<S> getReference() {
        return this.getReferenceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceReferenceImpl<S> getReferenceImpl() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            return this.reference;
        }
    }

    private Map<String, Object> createProperties(Dictionary<String, ?> p) {
        assert (Thread.holdsLock(this.registrationLock));
        ServiceProperties props = new ServiceProperties(p, 4);
        props.put("objectClass", this.clazzes);
        props.put("service.id", this.serviceid);
        props.put("service.bundleid", this.bundle.getBundleId());
        String scope = this.service instanceof ServiceFactory ? (this.service instanceof PrototypeServiceFactory ? "prototype" : "bundle") : "singleton";
        props.put("service.scope", scope);
        Object ranking = props.get("service.ranking");
        if (ranking instanceof Integer) {
            this.serviceranking = (Integer)ranking;
        } else {
            this.serviceranking = 0;
            if (ranking != null) {
                this.registry.getContainer().getEventPublisher().publishFrameworkEvent(16, this.getBundle(), new ServiceException("Invalid ranking type: " + ranking.getClass(), 0));
            }
        }
        return props.asUnmodifiableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String key) {
        Object object = this.registrationLock;
        synchronized (object) {
            return ServiceProperties.cloneValue(this.properties.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary<String, Object> getPropertiesCopy() {
        Object object = this.registrationLock;
        synchronized (object) {
            return new ServiceProperties(this.properties);
        }
    }

    long getId() {
        return this.serviceid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.serviceranking;
        }
    }

    String[] getClasses() {
        return this.clazzes;
    }

    S getServiceObject() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle getBundle() {
        Object object = this.registrationLock;
        synchronized (object) {
            block4: {
                if (this.reference != null) break block4;
                return null;
            }
            return this.bundle;
        }
    }

    public Bundle getRegisteringBundle() {
        return this.bundle;
    }

    S getSafeService(BundleContextImpl user, ServiceConsumer consumer) {
        try {
            return this.getService(user, consumer);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    S getService(BundleContextImpl user, ServiceConsumer consumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    ServiceObjectsImpl<S> getServiceObjects(BundleContextImpl user) {
        if (this.isUnregistered()) {
            return null;
        }
        if (this.registry.debug.DEBUG_SERVICES) {
            Debug.println("getServiceObjects[" + user.getBundleImpl() + "](" + this + ")");
        }
        return new ServiceObjectsImpl(user, this);
    }

    private ServiceUse<S> newServiceUse(BundleContextImpl user) {
        if (this.service instanceof ServiceFactory) {
            if (this.service instanceof PrototypeServiceFactory) {
                return new PrototypeServiceFactoryUse(user, this);
            }
            return new ServiceFactoryUse(user, this);
        }
        return new ServiceUse(user, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean ungetService(BundleContextImpl user, ServiceConsumer consumer, S serviceObject) {
        ServiceUse<?> use;
        if (this.isUnregistered()) {
            return false;
        }
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse = user.getServicesInUseMap();
        if (servicesInUse == null) {
            return false;
        }
        if (this.registry.debug.DEBUG_SERVICES) {
            Debug.println("ungetService[" + user.getBundleImpl() + "](" + this + ")");
        }
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map = servicesInUse;
        synchronized (map) {
            ServiceUse<?> u;
            use = u = servicesInUse.get(this);
            if (use == null) {
                return false;
            }
        }
        ServiceUse<?> serviceUse = use;
        synchronized (serviceUse) {
            boolean result = consumer.ungetService(use, serviceObject);
            if (!use.isEmpty()) return result;
            Map<ServiceRegistrationImpl<?>, ServiceUse<?>> map2 = servicesInUse;
            synchronized (map2) {
                Object object = this.registrationLock;
                synchronized (object) {
                    servicesInUse.remove(this);
                    this.contextsUsing.remove(user);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseService(BundleContextImpl user) {
        ServiceUse<?> use;
        Map<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                return;
            }
        }
        if (this.registry.debug.DEBUG_SERVICES) {
            Debug.println("releaseService[" + user.getBundleImpl() + "](" + this + ")");
        }
        if ((servicesInUse = user.getServicesInUseMap()) == null) {
            return;
        }
        Object object2 = servicesInUse;
        synchronized (object2) {
            Object object3 = this.registrationLock;
            synchronized (object3) {
                ServiceUse<?> u;
                use = u = servicesInUse.remove(this);
                if (use == null) {
                    return;
                }
                this.contextsUsing.remove(user);
            }
        }
        object2 = use;
        synchronized (object2) {
            use.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            int size;
            block7: {
                block6: {
                    if (this.state != 2) break block6;
                    return null;
                }
                size = this.contextsUsing.size();
                if (size != 0) break block7;
                return null;
            }
            Bundle[] bundles = new Bundle[size];
            int i = 0;
            while (i < size) {
                bundles[i] = this.contextsUsing.get(i).getBundleImpl();
                ++i;
            }
            return bundles;
        }
    }

    boolean isAssignableTo(Bundle client, String className) {
        return PackageSource.isServiceAssignableTo(this.bundle, client, className, this.service.getClass(), this.context.getContainer());
    }

    public String toString() {
        int size = this.clazzes.length;
        StringBuilder sb = new StringBuilder(50 * size);
        sb.append('{');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clazzes[i]);
            ++i;
        }
        sb.append("}=");
        sb.append(this.getProperties().toString());
        return sb.toString();
    }

    @Override
    public int compareTo(ServiceRegistrationImpl<?> other) {
        long otherId;
        int otherRanking;
        int thisRanking = this.getRanking();
        if (thisRanking != (otherRanking = other.getRanking())) {
            if (thisRanking < otherRanking) {
                return 1;
            }
            return -1;
        }
        long thisId = this.getId();
        if (thisId == (otherId = other.getId())) {
            return 0;
        }
        if (thisId < otherId) {
            return -1;
        }
        return 1;
    }
}

