/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=4000)
public class MessageSanitizerContainerResponseFilter
implements ContainerResponseFilter {
    private static final HashMap<String, String> replacementMap = new HashMap();

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        ArrayList contentTypes;
        Object entity;
        if (400 == responseContext.getStatus() && (entity = responseContext.getEntity()) != null && entity instanceof String && (contentTypes = (ArrayList)responseContext.getHeaders().get((Object)"Content-Type")) != null && contentTypes.contains("text/html")) {
            String escapedMsg = this.escapeXml((String)entity);
            responseContext.setEntity((Object)escapedMsg);
        }
    }

    private String escapeXml(String str) {
        StringBuilder sb = new StringBuilder();
        if (!str.isEmpty()) {
            for (String key : str.split("|")) {
                String value = replacementMap.get(key);
                if (value == null) {
                    sb.append(key);
                    continue;
                }
                sb.append(value);
            }
        }
        return sb.toString();
    }

    static {
        replacementMap.put("/", "&#x2F;");
        replacementMap.put("<", "&lt;");
        replacementMap.put(">", "&gt;");
        replacementMap.put("&", "&amp;");
        replacementMap.put("\"", "&quot;");
        replacementMap.put("'", "&#x27;");
    }
}

