/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.PathHelper;

public class Encode {
    private static final String UTF_8;
    private static final Pattern PARAM_REPLACEMENT;
    private static final String[] pathEncoding;
    private static final String[] pathSegmentEncoding;
    private static final String[] matrixParameterEncoding;
    private static final String[] queryNameValueEncoding;
    private static final String[] queryStringEncoding;
    private static final Pattern nonCodes;
    private static final Pattern encodedChars;
    private static final Pattern encodedCharsMulti;

    public static String encodeQueryString(String value) {
        return Encode.encodeValue(value, queryStringEncoding);
    }

    public static String encodePath(String value) {
        return Encode.encodeValue(value, pathEncoding);
    }

    public static String encodePathSegment(String value) {
        return Encode.encodeValue(value, pathSegmentEncoding);
    }

    public static String encodeFragment(String value) {
        return Encode.encodeValue(value, queryStringEncoding);
    }

    public static String encodeMatrixParam(String value) {
        return Encode.encodeValue(value, matrixParameterEncoding);
    }

    public static String encodeQueryParam(String value) {
        return Encode.encodeValue(value, queryNameValueEncoding);
    }

    public static String decodePath(String path) {
        Matcher matcher = encodedCharsMulti.matcher(path);
        int start = 0;
        StringBuilder builder = new StringBuilder();
        CharsetDecoder decoder = Charset.forName(UTF_8).newDecoder();
        while (matcher.find()) {
            builder.append(path, start, matcher.start());
            decoder.reset();
            String decoded = Encode.decodeBytes(matcher.group(1), decoder);
            builder.append(decoded);
            start = matcher.end();
        }
        builder.append(path, start, path.length());
        return builder.toString();
    }

    private static String decodeBytes(String enc, CharsetDecoder decoder) {
        Matcher matcher = encodedChars.matcher(enc);
        ByteBuffer bytes = ByteBuffer.allocate(enc.length() / 3);
        while (matcher.find()) {
            int b = Integer.parseInt(matcher.group(1), 16);
            bytes.put((byte)b);
        }
        bytes.flip();
        try {
            return decoder.decode(bytes).toString();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeNonCodes(String string) {
        Matcher matcher = nonCodes.matcher(string);
        StringBuilder builder = new StringBuilder();
        int idx = 0;
        while (matcher.find(idx)) {
            int start = matcher.start();
            builder.append(string.substring(idx, start));
            builder.append("%25");
            idx = start + 1;
        }
        builder.append(string.substring(idx));
        return builder.toString();
    }

    public static boolean savePathParams(String segment, StringBuilder newSegment, List<String> params) {
        boolean foundParam = false;
        segment = PathHelper.replaceEnclosedCurlyBraces(segment);
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        int start = 0;
        while (matcher.find()) {
            newSegment.append(segment, start, matcher.start());
            foundParam = true;
            String group = matcher.group();
            params.add(PathHelper.recoverEnclosedCurlyBraces(group));
            newSegment.append("_resteasy_uri_parameter");
            start = matcher.end();
        }
        newSegment.append(segment, start, segment.length());
        return foundParam;
    }

    public static String encodeValue(String segment, String[] encoding) {
        ArrayList<String> params = new ArrayList<String>();
        boolean foundParam = false;
        StringBuilder newSegment = new StringBuilder();
        if (Encode.savePathParams(segment, newSegment, params)) {
            foundParam = true;
            segment = newSegment.toString();
        }
        String result = Encode.encodeFromArray(segment, encoding, false);
        segment = result = Encode.encodeNonCodes(result);
        if (foundParam) {
            segment = Encode.pathParamReplacement(segment, params);
        }
        return segment;
    }

    public static String encodePathAsIs(String segment) {
        return Encode.encodeFromArray(segment, pathEncoding, true);
    }

    public static String encodePathSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, pathEncoding, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodePathSegmentAsIs(String segment) {
        return Encode.encodeFromArray(segment, pathSegmentEncoding, true);
    }

    public static String encodePathSegmentSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, pathSegmentEncoding, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodeQueryParamAsIs(String nameOrValue) {
        return Encode.encodeFromArray(nameOrValue, queryNameValueEncoding, true);
    }

    public static String encodeQueryParamSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, queryNameValueEncoding, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodeFragmentAsIs(String nameOrValue) {
        return Encode.encodeFromArray(nameOrValue, queryNameValueEncoding, true);
    }

    protected static String encodeFromArray(String segment, String[] encodingMap, boolean encodePercent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segment.length(); ++i) {
            char currentChar = segment.charAt(i);
            if (!encodePercent && currentChar == '%') {
                result.append(currentChar);
                continue;
            }
            String encoding = Encode.encode(currentChar, encodingMap);
            if (encoding == null) {
                result.append(currentChar);
                continue;
            }
            result.append(encoding);
        }
        return result.toString();
    }

    private static String encode(int zhar, String[] encodingMap) {
        String encoded;
        if (zhar < encodingMap.length) {
            encoded = encodingMap[zhar];
        } else {
            try {
                encoded = URLEncoder.encode(Character.toString((char)zhar), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return encoded;
    }

    public static String pathParamReplacement(String segment, List<String> params) {
        StringBuilder newSegment = new StringBuilder();
        Matcher matcher = PARAM_REPLACEMENT.matcher(segment);
        int i = 0;
        int start = 0;
        while (matcher.find()) {
            newSegment.append(segment, start, matcher.start());
            String replacement = params.get(i++);
            newSegment.append(replacement);
            start = matcher.end();
        }
        newSegment.append(segment, start, segment.length());
        segment = newSegment.toString();
        return segment;
    }

    public static MultivaluedMap<String, String> decode(MultivaluedMap<String, String> map) {
        MultivaluedMapImpl<String, String> decoded = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                try {
                    decoded.add(URLDecoder.decode((String)entry.getKey(), UTF_8), URLDecoder.decode(value, UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return decoded;
    }

    public static MultivaluedMap<String, String> decode(MultivaluedMap<String, String> map, String charset) {
        if (charset == null) {
            charset = UTF_8;
        }
        MultivaluedMapImpl<String, String> decoded = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                try {
                    decoded.add(URLDecoder.decode((String)entry.getKey(), charset), URLDecoder.decode(value, charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return decoded;
    }

    public static MultivaluedMap<String, String> encode(MultivaluedMap<String, String> map) {
        MultivaluedMapImpl<String, String> decoded = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                try {
                    decoded.add(URLEncoder.encode((String)entry.getKey(), UTF_8), URLEncoder.encode(value, UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return decoded;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int i;
        UTF_8 = StandardCharsets.UTF_8.name();
        PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");
        pathEncoding = new String[128];
        pathSegmentEncoding = new String[128];
        matrixParameterEncoding = new String[128];
        queryNameValueEncoding = new String[128];
        queryStringEncoding = new String[128];
        block11: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    continue block11;
                }
                default: {
                    Encode.pathEncoding[i] = URLEncoder.encode(String.valueOf((char)i));
                }
            }
        }
        Encode.pathEncoding[32] = "%20";
        System.arraycopy(pathEncoding, 0, matrixParameterEncoding, 0, pathEncoding.length);
        Encode.matrixParameterEncoding[59] = "%3B";
        Encode.matrixParameterEncoding[61] = "%3D";
        Encode.matrixParameterEncoding[47] = "%2F";
        System.arraycopy(pathEncoding, 0, pathSegmentEncoding, 0, pathEncoding.length);
        Encode.pathSegmentEncoding[47] = "%2F";
        block12: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '-': 
                case '.': 
                case '?': 
                case '_': 
                case '~': {
                    continue block12;
                }
                case ' ': {
                    Encode.queryNameValueEncoding[i] = "+";
                    continue block12;
                }
                default: {
                    Encode.queryNameValueEncoding[i] = URLEncoder.encode(String.valueOf((char)i));
                }
            }
        }
        block13: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    continue block13;
                }
                case ' ': {
                    Encode.queryStringEncoding[i] = "%20";
                    continue block13;
                }
                default: {
                    Encode.queryStringEncoding[i] = URLEncoder.encode(String.valueOf((char)i));
                }
            }
        }
        nonCodes = Pattern.compile("%([^a-fA-F0-9]|[a-fA-F0-9]$|$|[a-fA-F0-9][^a-fA-F0-9])");
        encodedChars = Pattern.compile("%([a-fA-F0-9][a-fA-F0-9])");
        encodedCharsMulti = Pattern.compile("((%[a-fA-F0-9][a-fA-F0-9])+)");
    }
}

