/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.weibo.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.weibo.exception.BusinessException;
import com.jeecg.weibo.util.HttpUtil;
import com.jeecg.weibo.util.WeiboUsersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiboUsersApi {
    private static final Logger logger = LoggerFactory.getLogger(WeiboUsersApi.class);
    private static final String show_url = "https://api.weibo.com/2/users/show.json?1=1";
    private static final String counts_url = "https://api.weibo.com/2/users/counts.json?1=1";

    public static JSONObject getShow(String access_token, String uid, String screen_name) {
        JSONObject j = null;
        try {
            logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u53c2\u6570\u4e3a:access_token:" + access_token + "    \u9700\u8981\u67e5\u8be2\u7684\u7528\u6237ID:" + uid + "     \u9700\u8981\u67e5\u8be2\u7684\u7528\u6237\u6635\u79f0:" + screen_name);
            WeiboUsersUtil.getShowParmValidate(access_token, uid, screen_name);
            String requestUrl = WeiboUsersUtil.getShowUrl(show_url, access_token, uid, screen_name);
            logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequest(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static JSONArray getCounts(String access_token, String uids) {
        JSONArray j = null;
        try {
            logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u53c2\u6570\u4e3a:access_token:" + access_token + "    \u9700\u8981\u67e5\u8be2\u7684\u7528\u6237ID:" + uids);
            WeiboUsersUtil.getCountsParmValidate(access_token, uids);
            String requestUrl = WeiboUsersUtil.getCountsUrl(counts_url, access_token, uids);
            logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u8def\u5f84\u4e3a:" + requestUrl);
            j = HttpUtil.httpRequestArr(requestUrl, "GET", null);
            if (j != null) {
                logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:" + j.toString());
            } else {
                logger.info("\u6839\u636e\u7528\u6237ID\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u7ed3\u679c\u4e3a:null");
            }
        }
        catch (BusinessException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    public static void main(String[] args) {
    }
}

