/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import java.util.Objects;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.artifactoryXrayResponse.InfectedFile;
import org.jfrog.build.client.artifactoryXrayResponse.Issue;
import org.jfrog.build.extractor.buildScanTable.ScanTableBase;

public class LicenseViolationsTable
extends ScanTableBase {
    public static final String LICENSE_VIOLATIONS_TABLE_HEADLINE = "License Compliance Violations";

    protected LicenseViolationsTable(Log log) {
        super(log);
    }

    @Override
    protected String getHeadline() {
        return LICENSE_VIOLATIONS_TABLE_HEADLINE;
    }

    @Override
    protected String[] getHeaders() {
        return new String[]{"#", "Severity", "Component"};
    }

    @Override
    protected String getTableFormat() {
        return super.getFormatBase(this.longestDisplayName);
    }

    @Override
    protected String getEmptyTableLine() {
        return "No license compliance violations were found";
    }

    protected void addElement(Issue issue, InfectedFile infectedFile) {
        LicenseTableElement element = new LicenseTableElement(infectedFile.getDisplayName(), infectedFile.getSha256(), issue.getSummary(), issue.getDescription());
        super.addElement(this.table, issue, element);
        if (infectedFile.getDisplayName() != null && infectedFile.getDisplayName().length() > this.longestDisplayName) {
            this.longestDisplayName = infectedFile.getDisplayName().length();
        }
    }

    protected void printTable() {
        super.printTable(this.table);
    }

    private static class LicenseTableElement
    extends ScanTableBase.TableElementBase {
        LicenseTableElement(String fileDisplayName, String fileSha256, String issueSummary, String issueDescription) {
            super(fileDisplayName, fileSha256, issueSummary, issueDescription);
        }

        @Override
        protected Object[] getLineArgs(int line, String severityName) {
            return new Object[]{line, severityName, this.getFileDisplayName()};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LicenseTableElement that = (LicenseTableElement)o;
            return Objects.equals(this.fileDisplayName, that.fileDisplayName) && Objects.equals(this.fileSha256, that.fileSha256) && Objects.equals(this.issueSummary, that.issueSummary) && Objects.equals(this.issueDescription, that.issueDescription);
        }

        public int hashCode() {
            return Objects.hash(this.fileDisplayName, this.fileSha256, this.issueSummary, this.issueDescription);
        }
    }
}

