/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.BuildPatternArtifactsRequest;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;
import org.jfrog.build.extractor.clientConfiguration.util.JsonSerializer;

public class RetrievePatternArtifacts
extends JFrogService<List<BuildPatternArtifacts>> {
    private static final String PATTERN_ARTIFACT_REST_URL = "/api/build/patternArtifacts";
    private final List<BuildPatternArtifactsRequest> requests;

    public RetrievePatternArtifacts(List<BuildPatternArtifactsRequest> requests, Log logger) {
        super(logger);
        this.requests = requests;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        this.log.info("Retrieving build artifacts report from: /api/build/patternArtifacts");
        HttpPost req = new HttpPost(PATTERN_ARTIFACT_REST_URL);
        String json = new JsonSerializer<List<BuildPatternArtifactsRequest>>().toJSON(this.requests);
        StringEntity stringEntity = new StringEntity(json);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        req.setEntity((HttpEntity)stringEntity);
        return req;
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, (JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, BuildPatternArtifacts.class));
    }
}

