/*
 * Decompiled with CFR 0.152.
 */
package jodd.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import jodd.cli.CliException;
import jodd.cli.Option;
import jodd.cli.Param;

public class Cli
implements Consumer<String[]> {
    private final List<Option> options = new ArrayList<Option>();
    private final List<Param> params = new ArrayList<Param>();

    public Option option() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public Param param() {
        Param param = new Param();
        this.params.add(param);
        return param;
    }

    private boolean consumeOptionWithLongName(String input, String valueToConsume) {
        for (Option option : this.options) {
            if (input.equals(option.longName)) {
                if (option.hasArg && valueToConsume == null) {
                    throw new CliException("Option value not provided for: " + input);
                }
                option.consumer.accept(option.hasArg ? valueToConsume : input);
                return option.hasArg;
            }
            if (option.longName == null || !input.startsWith(option.longName + "=")) continue;
            option.consumer.accept(input.substring(option.longName.length() + 1));
            return false;
        }
        throw new CliException("Unknown option: " + input);
    }

    private boolean consumeOptionWithShortName(String input, String valueToConsume) {
        for (Option option : this.options) {
            if (input.equals(option.shortName)) {
                if (option.hasArg) {
                    if (valueToConsume == null) {
                        throw new CliException("Option value not provided for: " + input);
                    }
                    option.consumer.accept(valueToConsume);
                    return true;
                }
                option.consumer.accept(input);
                return false;
            }
            if (option.shortName == null || !input.startsWith(option.shortName + "=")) continue;
            option.consumer.accept(input.substring(option.shortName.length() + 1));
            return false;
        }
        throw new CliException("Unknown option: " + input);
    }

    private void consumeOptionWithShortNameAndNoArguments(String shortName) {
        for (Option option : this.options) {
            if (!shortName.equals(option.shortName) || option.hasArg) continue;
            option.consumer.accept(shortName);
            return;
        }
        throw new CliException("Unknown option: " + shortName);
    }

    @Override
    public void accept(String ... args) {
        this.assertConfigurationIsValid();
        boolean dontParseOptionsAnyMore = false;
        int paramsIndex = 0;
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if (arg.isEmpty()) continue;
            String string = value = i + 1 < args.length ? args[i + 1] : null;
            if (arg.equals("--")) {
                dontParseOptionsAnyMore = true;
                continue;
            }
            if (!dontParseOptionsAnyMore) {
                if (arg.startsWith("--")) {
                    String argLongName = arg.substring(2);
                    this.consumeOptionWithLongName(argLongName, value);
                    args[i] = null;
                    continue;
                }
                if (arg.startsWith("-")) {
                    String argShortName = arg.substring(1);
                    if (argShortName.length() > 1 && argShortName.charAt(1) != '=') {
                        char[] allShortNames;
                        for (char c : allShortNames = argShortName.toCharArray()) {
                            String argName = String.valueOf(c);
                            this.consumeOptionWithShortNameAndNoArguments(argName);
                        }
                        args[i] = null;
                        continue;
                    }
                    boolean valueConsumed = this.consumeOptionWithShortName(argShortName, value);
                    args[i] = null;
                    if (!valueConsumed) continue;
                    args[++i] = null;
                    continue;
                }
            }
            if (paramsIndex == this.params.size()) break;
            Param param = this.params.get(paramsIndex++);
            ArrayList<String> paramArguments = new ArrayList<String>();
            int from = 0;
            int to = param.required + param.optional;
            while (from < to) {
                String paramValue;
                String string2 = paramValue = i < args.length ? args[i] : null;
                if (paramValue == null) break;
                paramArguments.add(paramValue);
                ++from;
                ++i;
            }
            --i;
            if (paramArguments.size() < param.required) {
                throw new CliException("Parameter required: " + param.label);
            }
            if (paramArguments.isEmpty()) continue;
            param.consumer.accept(paramArguments.toArray(new String[0]));
        }
        while (paramsIndex < this.params.size()) {
            Param param = this.params.get(paramsIndex++);
            if (param.required <= 0) continue;
            throw new CliException("Parameter required: " + param.label);
        }
    }

    private void assertConfigurationIsValid() {
        for (Option option : this.options) {
            if (option.consumer != null) continue;
            throw new CliException("Option has no registered consumer: " + option);
        }
    }

    public void printUsage(String commandName) {
        StringBuilder usage = new StringBuilder(commandName);
        for (Option option : this.options) {
            if (option.shortName != null) {
                usage.append(" [-").append(option.shortName).append("]");
                continue;
            }
            if (option.longName == null) continue;
            usage.append(" [--").append(option.longName).append("]");
        }
        for (Param param : this.params) {
            usage.append(" ").append(param.label);
        }
        System.out.println(usage);
    }
}

