/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.VariableElement;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.prism.ContextPrism;
import org.mapstruct.ap.internal.prism.MappingTargetPrism;
import org.mapstruct.ap.internal.prism.TargetTypePrism;
import org.mapstruct.ap.internal.util.Collections;

public class Parameter
extends ModelElement {
    private final String name;
    private final String originalName;
    private final Type type;
    private final boolean mappingTarget;
    private final boolean targetType;
    private final boolean mappingContext;
    private final boolean varArgs;

    private Parameter(String name, Type type, boolean mappingTarget, boolean targetType, boolean mappingContext, boolean varArgs) {
        this.name = name;
        this.originalName = name;
        this.type = type;
        this.mappingTarget = mappingTarget;
        this.targetType = targetType;
        this.mappingContext = mappingContext;
        this.varArgs = varArgs;
    }

    public Parameter(String name, Type type) {
        this(name, type, false, false, false, false);
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isMappingTarget() {
        return this.mappingTarget;
    }

    public String toString() {
        return (this.mappingTarget ? "@MappingTarget " : "") + (this.targetType ? "@TargetType " : "") + (this.mappingContext ? "@Context " : "") + this.type.toString() + " " + this.name;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.asSet(this.type);
    }

    public boolean isTargetType() {
        return this.targetType;
    }

    public boolean isMappingContext() {
        return this.mappingContext;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
            return false;
        }
        return this.type != null ? this.type.equals(parameter.type) : parameter.type == null;
    }

    public static Parameter forElementAndType(VariableElement element, Type parameterType, boolean isVarArgs) {
        return new Parameter(element.getSimpleName().toString(), parameterType, MappingTargetPrism.getInstanceOn(element) != null, TargetTypePrism.getInstanceOn(element) != null, ContextPrism.getInstanceOn(element) != null, isVarArgs);
    }

    public static Parameter forForgedMappingTarget(Type parameterType) {
        return new Parameter("mappingTarget", parameterType, true, false, false, false);
    }

    public static List<Parameter> getSourceParameters(List<Parameter> parameters) {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter parameter : parameters) {
            if (parameter.isMappingTarget() || parameter.isTargetType() || parameter.isMappingContext()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    public static List<Parameter> getContextParameters(List<Parameter> parameters) {
        ArrayList<Parameter> contextParameters = new ArrayList<Parameter>(parameters.size());
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingContext()) continue;
            contextParameters.add(parameter);
        }
        return contextParameters;
    }

    public static Parameter getMappingTargetParameter(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isMappingTarget()) continue;
            return parameter;
        }
        return null;
    }

    public static Parameter getTargetTypeParameter(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isTargetType()) continue;
            return parameter;
        }
        return null;
    }
}

