/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.util.StringUtil;
import org.mockito.internal.util.Supplier;

public class MockAnnotationProcessor
implements FieldAnnotationProcessor<Mock> {
    @Override
    public Object process(Mock annotation, Field field) {
        return MockAnnotationProcessor.processAnnotationForMock(annotation, field.getType(), field::getGenericType, field.getName());
    }

    public static Object processAnnotationForMock(Mock annotation, Class<?> type, Supplier<Type> genericType, String name) {
        MockSettings mockSettings = Mockito.withSettings();
        if (annotation.extraInterfaces().length > 0) {
            mockSettings.extraInterfaces(annotation.extraInterfaces());
        }
        if ("".equals(annotation.name())) {
            mockSettings.name(name);
        } else {
            mockSettings.name(annotation.name());
        }
        if (annotation.serializable()) {
            mockSettings.serializable();
        }
        if (annotation.stubOnly()) {
            mockSettings.stubOnly();
        }
        if (annotation.lenient()) {
            mockSettings.lenient();
        }
        mockSettings.defaultAnswer(annotation.answer());
        if (type == MockedStatic.class) {
            return Mockito.mockStatic(MockAnnotationProcessor.inferParameterizedType(genericType.get(), name, MockedStatic.class.getSimpleName()), mockSettings);
        }
        if (type == MockedConstruction.class) {
            return Mockito.mockConstruction(MockAnnotationProcessor.inferParameterizedType(genericType.get(), name, MockedConstruction.class.getSimpleName()), mockSettings);
        }
        return Mockito.mock(type, mockSettings);
    }

    static Class<?> inferParameterizedType(Type type, String name, String sort) {
        ParameterizedType parameterizedType;
        Type[] arguments;
        if (type instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1 && arguments[0] instanceof Class) {
            return (Class)arguments[0];
        }
        throw new MockitoException(StringUtil.join("Mockito cannot infer a static mock from a raw type for " + name, "", "Instead of @Mock " + sort + " you need to specify a parameterized type", "For example, if you would like to mock Sample.class, specify", "", "@Mock " + sort + "<Sample>", "", "as the type parameter. If the type is itself parameterized, it should be specified as raw type."));
    }
}

