/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.powermock.api.mockito.expectation.PowerMockitoStubber;
import org.powermock.api.mockito.expectation.PrivatelyExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DefaultPrivatelyExpectedArguments;
import org.powermock.api.mockito.invocation.MockitoMethodInvocationControl;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;

public class PowerMockitoStubberImpl
implements PowerMockitoStubber,
Stubber {
    private final Stubber stubber;

    public PowerMockitoStubberImpl(Stubber stubber) {
        this.stubber = stubber;
    }

    public <T> T when(T instanceMock) {
        Object returnValue;
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(instanceMock);
        if (invocationControl == null) {
            returnValue = this.stubber.when(instanceMock);
        } else {
            Object mock = invocationControl.getMockHandlerAdaptor().getMock();
            this.stubber.when(mock);
            returnValue = instanceMock;
        }
        return (T)returnValue;
    }

    public Stubber doThrow(Throwable ... toBeThrown) {
        return this.stubber.doThrow(toBeThrown);
    }

    public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return this.stubber.doThrow(toBeThrown);
    }

    public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable>[] nextToBeThrown) {
        return this.stubber.doThrow(toBeThrown, (Class[])nextToBeThrown);
    }

    public Stubber doAnswer(Answer answer) {
        return this.stubber.doAnswer(answer);
    }

    public Stubber doNothing() {
        return this.stubber.doNothing();
    }

    public Stubber doReturn(Object toBeReturned) {
        return this.stubber.doReturn(toBeReturned);
    }

    public Stubber doReturn(Object toBeReturned, Object ... nextToBeReturned) {
        return this.stubber.doReturn(toBeReturned, nextToBeReturned);
    }

    public Stubber doCallRealMethod() {
        return this.stubber.doCallRealMethod();
    }

    @Override
    public void when(Class<?> classMock) {
        MockitoMethodInvocationControl invocationControl = (MockitoMethodInvocationControl)MockRepository.getStaticMethodInvocationControl(classMock);
        Object mock = invocationControl.getMockHandlerAdaptor().getMock();
        this.stubber.when(mock);
    }

    @Override
    public <T> PrivatelyExpectedArguments when(T mock, Method method) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(method, "Method");
        this.when(mock);
        return new DefaultPrivatelyExpectedArguments(mock, method);
    }

    @Override
    public <T> void when(T mock, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.when(mock);
        Whitebox.invokeMethod(mock, (Object[])arguments);
    }

    @Override
    public <T> void when(T mock, String methodToExpect, Object ... arguments) throws Exception {
        this.assertNotNull(mock, "mock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.when(mock);
        Whitebox.invokeMethod(mock, (String)methodToExpect, (Object[])arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, Object ... arguments) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.when(classMock);
        Whitebox.invokeMethod(classMock, (Object[])arguments);
    }

    @Override
    public <T> void when(Class<T> classMock, String methodToExpect, Object ... parameters) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(methodToExpect, "methodToExpect");
        this.when(classMock);
        Whitebox.invokeMethod(classMock, (String)methodToExpect, (Object[])parameters);
    }

    @Override
    public <T> PrivatelyExpectedArguments when(Class<T> classMock, Method method) throws Exception {
        this.assertNotNull(classMock, "classMock");
        this.assertNotNull(method, "Method");
        this.when(classMock);
        return new DefaultPrivatelyExpectedArguments(classMock, method);
    }

    private void assertNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }
}

