/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.rule;

import org.junit.runners.model.Statement;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.classloading.ClassloaderExecutor;
import org.powermock.classloading.SingleClassloaderExecutor;
import org.powermock.core.MockRepository;
import org.powermock.tests.utils.MockPolicyInitializer;
import org.powermock.tests.utils.TestChunk;

class PowerMockStatement
extends Statement {
    private final Statement fNext;
    private final ClassloaderExecutor classloaderExecutor;
    private final MockPolicyInitializer mockPolicyInitializer;

    public PowerMockStatement(Statement fNext, TestChunk testChunk, MockPolicyInitializer mockPolicyInitializer) {
        this.fNext = fNext;
        this.mockPolicyInitializer = mockPolicyInitializer;
        this.classloaderExecutor = new SingleClassloaderExecutor(testChunk.getClassLoader());
    }

    public void evaluate() throws Throwable {
        this.classloaderExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PowerMockStatement.this.mockPolicyInitializer.refreshPolicies(this.getClass().getClassLoader());
                    PowerMockStatement.this.fNext.evaluate();
                }
                catch (Throwable e) {
                    SafeExceptionRethrower.safeRethrow((Throwable)e);
                }
                finally {
                    MockRepository.clear();
                }
            }
        });
    }
}

