/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal;

import java.util.concurrent.TimeUnit;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

class TimeLimitedStatement
extends Statement {
    private final long timeout;
    private final Statement delegate;

    public TimeLimitedStatement(long timeout, Statement delegate) {
        this.timeout = timeout;
        this.delegate = delegate;
    }

    public void evaluate() throws Throwable {
        Thread testThread = Thread.currentThread();
        Thread timeoutThread = new Thread(() -> {
            try {
                Thread.sleep(this.timeout);
                testThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, "Robolectric time-limited test");
        timeoutThread.start();
        try {
            this.delegate.evaluate();
        }
        catch (InterruptedException e) {
            TestTimedOutException e2 = new TestTimedOutException(this.timeout, TimeUnit.MILLISECONDS);
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        finally {
            timeoutThread.interrupt();
            timeoutThread.join();
        }
    }
}

