/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.robolectric.internal.TimeLimitedStatement;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.InvokeDynamic;
import org.robolectric.internal.bytecode.InvokeDynamicClassInstrumentor;
import org.robolectric.internal.bytecode.OldClassInstrumentor;
import org.robolectric.internal.bytecode.ResourceProvider;
import org.robolectric.internal.bytecode.Sandbox;
import org.robolectric.internal.bytecode.SandboxConfig;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.internal.bytecode.ShadowProviders;
import org.robolectric.internal.bytecode.ShadowWrangler;
import org.robolectric.internal.bytecode.UrlResourceProvider;
import org.robolectric.pluginapi.perf.Metadata;
import org.robolectric.pluginapi.perf.PerfStatsReporter;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.Util;
import org.robolectric.util.inject.Injector;

public class SandboxTestRunner
extends BlockJUnit4ClassRunner {
    private static final Injector DEFAULT_INJECTOR = SandboxTestRunner.defaultInjector().build();
    private final ClassInstrumentor classInstrumentor;
    private final Interceptors interceptors;
    private final ShadowProviders shadowProviders;
    private final List<PerfStatsReporter> perfStatsReporters;
    private final HashSet<Class<?>> loadedTestClasses = new HashSet();

    protected static Injector.Builder defaultInjector() {
        return new Injector.Builder().bindDefault(ClassInstrumentor.class, InvokeDynamic.ENABLED ? InvokeDynamicClassInstrumentor.class : OldClassInstrumentor.class);
    }

    public SandboxTestRunner(Class<?> klass) throws InitializationError {
        this(klass, DEFAULT_INJECTOR);
    }

    public SandboxTestRunner(Class<?> klass, Injector injector) throws InitializationError {
        super(klass);
        this.classInstrumentor = (ClassInstrumentor)injector.getInstance(ClassInstrumentor.class);
        this.interceptors = new Interceptors(this.findInterceptors());
        this.shadowProviders = (ShadowProviders)injector.getInstance(ShadowProviders.class);
        this.perfStatsReporters = Arrays.asList((PerfStatsReporter[])injector.getInstance(PerfStatsReporter[].class));
    }

    @Nonnull
    protected Collection<Interceptor> findInterceptors() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Interceptors getInterceptors() {
        return this.interceptors;
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement statement = this.childrenInvoker(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                    for (Class testClass : SandboxTestRunner.this.loadedTestClasses) {
                        SandboxTestRunner.invokeAfterClass(testClass);
                    }
                }
                finally {
                    SandboxTestRunner.this.afterClass();
                    SandboxTestRunner.this.loadedTestClasses.clear();
                }
            }
        };
    }

    private void invokeBeforeClass(Class clazz) throws Throwable {
        if (!this.loadedTestClasses.contains(clazz)) {
            this.loadedTestClasses.add(clazz);
            TestClass testClass = new TestClass(clazz);
            List befores = testClass.getAnnotatedMethods(BeforeClass.class);
            for (FrameworkMethod before : befores) {
                before.invokeExplosively(null, new Object[0]);
            }
        }
    }

    private static void invokeAfterClass(Class<?> clazz) throws Throwable {
        TestClass testClass = new TestClass(clazz);
        List afters = testClass.getAnnotatedMethods(AfterClass.class);
        for (FrameworkMethod after : afters) {
            after.invokeExplosively(null, new Object[0]);
        }
    }

    protected void afterClass() {
    }

    @Nonnull
    protected Sandbox getSandbox(FrameworkMethod method) {
        InstrumentationConfiguration instrumentationConfiguration = this.createClassLoaderConfig(method);
        return new Sandbox(instrumentationConfiguration, (ResourceProvider)new UrlResourceProvider(new URL[0]), this.classInstrumentor);
    }

    @Nonnull
    protected InstrumentationConfiguration createClassLoaderConfig(FrameworkMethod method) {
        InstrumentationConfiguration.Builder builder = InstrumentationConfiguration.newBuilder().doNotAcquirePackage("java.").doNotAcquirePackage("sun.").doNotAcquirePackage("org.robolectric.annotation.").doNotAcquirePackage("org.robolectric.internal.").doNotAcquirePackage("org.robolectric.pluginapi.").doNotAcquirePackage("org.robolectric.util.").doNotAcquirePackage("org.junit.");
        String customPackages = System.getProperty("org.robolectric.packagesToNotAcquire", "");
        for (String pkg : customPackages.split(",")) {
            if (pkg.isEmpty()) continue;
            builder.doNotAcquirePackage(pkg);
        }
        for (Class<?> shadowClass : this.getExtraShadows(method)) {
            ShadowInfo shadowInfo = ShadowMap.obtainShadowInfo((Class)shadowClass);
            builder.addInstrumentedClass(shadowInfo.shadowedClassName);
        }
        this.addInstrumentedPackages(method, builder);
        return builder.build();
    }

    private void addInstrumentedPackages(FrameworkMethod method, InstrumentationConfiguration.Builder builder) {
        SandboxConfig methodConfig;
        SandboxConfig classConfig = this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class);
        if (classConfig != null) {
            for (String pkgName : classConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
        if ((methodConfig = (SandboxConfig)method.getAnnotation(SandboxConfig.class)) != null) {
            for (String pkgName : methodConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
    }

    protected void configureSandbox(Sandbox sandbox, FrameworkMethod method) {
        ShadowMap.Builder builder = this.shadowProviders.getBaseShadowMap().newBuilder();
        Class[] shadows = this.getExtraShadows(method);
        if (shadows.length > 0) {
            builder.addShadowClasses(shadows);
        }
        ShadowMap shadowMap = builder.build();
        sandbox.replaceShadowMap(shadowMap);
        sandbox.configure(this.createClassHandler(shadowMap, sandbox), this.getInterceptors());
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PerfStatsCollector perfStatsCollector = PerfStatsCollector.getInstance();
                perfStatsCollector.reset();
                perfStatsCollector.setEnabled(!SandboxTestRunner.this.perfStatsReporters.isEmpty());
                PerfStatsCollector.Event initialization = perfStatsCollector.startEvent("initialization");
                Sandbox sandbox = SandboxTestRunner.this.getSandbox(method);
                SandboxTestRunner.this.configureSandbox(sandbox, method);
                sandbox.runOnMainThread(() -> {
                    Method bootstrappedMethod;
                    ClassLoader priorContextClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
                    Class bootstrappedTestClass = sandbox.bootstrappedClass(SandboxTestRunner.this.getTestClass().getJavaClass());
                    HelperTestRunner helperTestRunner = SandboxTestRunner.this.getHelperTestRunner(bootstrappedTestClass);
                    helperTestRunner.frameworkMethod = method;
                    try {
                        bootstrappedMethod = bootstrappedTestClass.getMethod(method.getMethod().getName(), new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        SandboxTestRunner.this.invokeBeforeClass(bootstrappedTestClass);
                        SandboxTestRunner.this.beforeTest(sandbox, method, bootstrappedMethod);
                        initialization.finished();
                        Statement statement = helperTestRunner.methodBlock(new FrameworkMethod(bootstrappedMethod));
                        try {
                            statement.evaluate();
                        }
                        finally {
                            SandboxTestRunner.this.afterTest(method, bootstrappedMethod);
                        }
                    }
                    catch (Throwable throwable) {
                        throw Util.sneakyThrow((Throwable)throwable);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(priorContextClassLoader);
                        try {
                            SandboxTestRunner.this.finallyAfterTest(method);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                SandboxTestRunner.this.reportPerfStats(perfStatsCollector);
                perfStatsCollector.reset();
            }
        };
    }

    private void reportPerfStats(PerfStatsCollector perfStatsCollector) {
        if (this.perfStatsReporters.isEmpty()) {
            return;
        }
        Metadata metadata = perfStatsCollector.getMetadata();
        Collection metrics = perfStatsCollector.getMetrics();
        for (PerfStatsReporter perfStatsReporter : this.perfStatsReporters) {
            try {
                perfStatsReporter.report(metadata, metrics);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void beforeTest(Sandbox sandbox, FrameworkMethod method, Method bootstrappedMethod) throws Throwable {
    }

    protected void afterTest(FrameworkMethod method, Method bootstrappedMethod) {
    }

    protected void finallyAfterTest(FrameworkMethod method) {
    }

    protected HelperTestRunner getHelperTestRunner(Class bootstrappedTestClass) {
        try {
            return new HelperTestRunner(bootstrappedTestClass);
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException(initializationError);
        }
    }

    @Nonnull
    protected Class<?>[] getExtraShadows(FrameworkMethod method) {
        ArrayList shadowClasses = new ArrayList();
        this.addShadows(shadowClasses, this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class));
        this.addShadows(shadowClasses, (SandboxConfig)method.getAnnotation(SandboxConfig.class));
        return shadowClasses.toArray(new Class[shadowClasses.size()]);
    }

    private void addShadows(List<Class<?>> shadowClasses, SandboxConfig annotation) {
        if (annotation != null) {
            shadowClasses.addAll(Arrays.asList(annotation.shadows()));
        }
    }

    @Nonnull
    protected ClassHandler createClassHandler(ShadowMap shadowMap, Sandbox sandbox) {
        return new ShadowWrangler(shadowMap, 0, this.interceptors);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        return next;
    }

    protected static class HelperTestRunner
    extends BlockJUnit4ClassRunner {
        public FrameworkMethod frameworkMethod;

        public HelperTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        protected Statement methodBlock(FrameworkMethod method) {
            return super.methodBlock(method);
        }

        protected Statement methodInvoker(FrameworkMethod method, Object test) {
            Statement delegate = super.methodInvoker(method, test);
            long timeout = this.getTimeout((Test)method.getAnnotation(Test.class));
            if (timeout == 0L) {
                return delegate;
            }
            return new TimeLimitedStatement(timeout, delegate);
        }

        protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
            return next;
        }

        private long getTimeout(Test annotation) {
            if (annotation == null) {
                return 0L;
            }
            return annotation.timeout();
        }
    }
}

