/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ResourcePath {
    private final Class<?> rClass;
    private final Path resourceBase;
    private final Path assetsDir;
    private final Class<?> internalRClass;

    public ResourcePath(Class<?> rClass, Path resourceBase, Path assetsDir) {
        this(rClass, resourceBase, assetsDir, null);
    }

    public ResourcePath(Class<?> rClass, Path resourceBase, Path assetsDir, Class<?> internalRClass) {
        this.rClass = rClass;
        this.resourceBase = resourceBase;
        this.assetsDir = assetsDir;
        this.internalRClass = internalRClass;
    }

    public Class<?> getRClass() {
        return this.rClass;
    }

    public Path getResourceBase() {
        return this.resourceBase;
    }

    public boolean hasResources() {
        return this.getResourceBase() != null && Files.exists(this.getResourceBase(), new LinkOption[0]);
    }

    public Path getAssetsDir() {
        return this.assetsDir;
    }

    public Class<?> getInternalRClass() {
        return this.internalRClass;
    }

    public String toString() {
        return "ResourcePath { path=" + this.resourceBase + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePath that = (ResourcePath)o;
        if (this.rClass != null ? !this.rClass.equals(that.rClass) : that.rClass != null) {
            return false;
        }
        if (this.resourceBase != null ? !this.resourceBase.equals(that.resourceBase) : that.resourceBase != null) {
            return false;
        }
        if (this.assetsDir != null ? !this.assetsDir.equals(that.assetsDir) : that.assetsDir != null) {
            return false;
        }
        return this.internalRClass != null ? this.internalRClass.equals(that.internalRClass) : that.internalRClass == null;
    }

    public int hashCode() {
        int result = this.rClass != null ? this.rClass.hashCode() : 0;
        result = 31 * result + (this.resourceBase != null ? this.resourceBase.hashCode() : 0);
        result = 31 * result + (this.assetsDir != null ? this.assetsDir.hashCode() : 0);
        result = 31 * result + (this.internalRClass != null ? this.internalRClass.hashCode() : 0);
        return result;
    }
}

