/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.ResourceHelper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MetaData {
    private final Map<String, Object> valueMap = new LinkedHashMap<String, Object>();
    private final Map<String, VALUE_TYPE> typeMap = new LinkedHashMap<String, VALUE_TYPE>();
    private boolean initialised;

    public MetaData(List<Node> nodes) {
        for (Node metaNode : nodes) {
            NamedNodeMap attributes = metaNode.getAttributes();
            Node nameAttr = attributes.getNamedItem("android:name");
            Node valueAttr = attributes.getNamedItem("android:value");
            Node resourceAttr = attributes.getNamedItem("android:resource");
            if (valueAttr != null) {
                this.valueMap.put(nameAttr.getNodeValue(), valueAttr.getNodeValue());
                this.typeMap.put(nameAttr.getNodeValue(), VALUE_TYPE.VALUE);
                continue;
            }
            if (resourceAttr == null) continue;
            this.valueMap.put(nameAttr.getNodeValue(), resourceAttr.getNodeValue());
            this.typeMap.put(nameAttr.getNodeValue(), VALUE_TYPE.RESOURCE);
        }
    }

    public void init(ResourceLoader resLoader, String packageName) {
        ResourceIndex resIndex = resLoader.getResourceIndex();
        if (!this.initialised) {
            for (Map.Entry<String, VALUE_TYPE> entry : this.typeMap.entrySet()) {
                String value = this.valueMap.get(entry.getKey()).toString();
                if (value.startsWith("@")) {
                    ResName resName = ResName.qualifyResName(value.substring(1), packageName, null);
                    block0 : switch (entry.getValue()) {
                        case RESOURCE: {
                            this.valueMap.put(entry.getKey(), resIndex.getResourceId(resName));
                            break;
                        }
                        case VALUE: {
                            TypedResource typedRes = resLoader.getValue(resName, "");
                            switch (typedRes.getResType()) {
                                case BOOLEAN: 
                                case COLOR: 
                                case INTEGER: 
                                case FLOAT: {
                                    this.valueMap.put(entry.getKey(), this.parseValue(typedRes.getData().toString()));
                                    break block0;
                                }
                            }
                            this.valueMap.put(entry.getKey(), typedRes.getData());
                        }
                    }
                    continue;
                }
                if (entry.getValue() != VALUE_TYPE.VALUE) continue;
                this.valueMap.put(entry.getKey(), this.parseValue(value));
            }
            this.initialised = true;
        }
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    private Object parseValue(String value) {
        if (value == null) {
            return null;
        }
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        if (value.startsWith("#")) {
            try {
                return ResourceHelper.getColor(value);
            }
            catch (NumberFormatException e) {
            }
        } else if (value.contains(".")) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
            }
        } else {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    private static enum VALUE_TYPE {
        RESOURCE,
        VALUE;

    }
}

