/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FsFile;

public class ResourcePath {
    public final Class<?> rClass;
    public final String packageName;
    public final FsFile resourceBase;
    public final FsFile assetsDir;
    public final FsFile rawDir;

    public ResourcePath(Class<?> rClass, String packageName, FsFile resourceBase, FsFile assetsDir) {
        this.rClass = rClass;
        this.packageName = packageName;
        this.resourceBase = resourceBase;
        this.assetsDir = assetsDir;
        FsFile rawDir = resourceBase.join("raw");
        this.rawDir = rawDir.exists() ? rawDir : null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "ResourcePath{package=" + this.getPackageName() + ", path=" + this.resourceBase + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePath)) {
            return false;
        }
        ResourcePath that = (ResourcePath)o;
        if (!this.assetsDir.equals(that.assetsDir)) {
            return false;
        }
        if (!this.packageName.equals(that.packageName)) {
            return false;
        }
        if (!(this.rClass != null ? this.rClass.equals(that.rClass) : that.rClass == null)) {
            return false;
        }
        if (!(this.rawDir != null ? this.rawDir.equals(that.rawDir) : that.rawDir == null)) {
            return false;
        }
        return this.resourceBase.equals(that.resourceBase);
    }

    public int hashCode() {
        int result = this.rClass != null ? this.rClass.hashCode() : 0;
        result = 31 * result + this.packageName.hashCode();
        result = 31 * result + this.resourceBase.hashCode();
        result = 31 * result + this.assetsDir.hashCode();
        if (this.rawDir != null) {
            result = 31 * result + this.rawDir.hashCode();
        }
        return result;
    }
}

