/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.AttributeSet;
import android.util.TypedValue;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.res.AttrData;
import org.robolectric.res.Attribute;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIndex;
import org.robolectric.res.ResourceLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.Converter;

public class RoboAttributeSet
implements AttributeSet {
    private final List<Attribute> attributes;
    private final ResourceLoader resourceLoader;

    public RoboAttributeSet(List<Attribute> attributes, ResourceLoader resourceLoader) {
        this.attributes = attributes;
        this.resourceLoader = resourceLoader;
    }

    public RoboAttributeSet put(String fullyQualifiedName, String value, String valuePackage) {
        return this.put(new Attribute(fullyQualifiedName, value, valuePackage));
    }

    public RoboAttributeSet put(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        ResName resName = this.getAttrResName(namespace, attribute);
        Attribute attr = this.findByName(resName);
        return attr != null ? Boolean.valueOf(attr.value) : defaultValue;
    }

    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        ResName resName = this.getAttrResName(namespace, attribute);
        Attribute attr = this.findByName(resName);
        if (attr == null) {
            return defaultValue;
        }
        String qualifiers = RuntimeEnvironment.getQualifiers();
        TypedResource<AttrData> typedResource = this.resourceLoader.getValue(resName, qualifiers);
        if (typedResource == null) {
            typedResource = new TypedResource<AttrData>(new AttrData(attribute, "integer", null), ResType.INTEGER);
        }
        TypedValue outValue = new TypedValue();
        Converter.convertAndFill(attr, outValue, this.resourceLoader, qualifiers, typedResource.getData(), false);
        if (outValue.type == 0) {
            return defaultValue;
        }
        return outValue.data;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeName(int index) {
        return this.attributes.get((int)index).resName.getFullyQualifiedName();
    }

    public String getAttributeValue(String namespace, String attribute) {
        ResName resName = this.getAttrResName(namespace, attribute);
        Attribute attr = this.findByName(resName);
        if (attr != null && !attr.isNull()) {
            return attr.qualifiedValue();
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (index > this.attributes.size()) {
            return null;
        }
        Attribute attr = this.attributes.get(index);
        if (attr != null && !attr.isNull()) {
            return attr.qualifiedValue();
        }
        return null;
    }

    public String getPositionDescription() {
        return "position description from RoboAttributeSet -- implement me!";
    }

    public int getAttributeNameResource(int index) {
        ResName resName = this.attributes.get((int)index).resName;
        Integer resourceId = this.resourceLoader.getResourceIndex().getResourceId(resName);
        return resourceId == null ? 0 : resourceId;
    }

    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        ResName resName = this.getAttrResName(namespace, attribute);
        Attribute attr = this.findByName(resName);
        return attr != null ? Float.valueOf(attr.value).floatValue() : defaultValue;
    }

    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean getAttributeBooleanValue(int resourceId, boolean defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        ResName resName = this.getAttrResName(namespace, attribute);
        Attribute attr = this.findByName(resName);
        if (attr == null) {
            return defaultValue;
        }
        Integer resourceId = ResName.getResourceId(this.resourceLoader.getResourceIndex(), attr.value, attr.contextPackageName);
        return resourceId == null ? defaultValue : resourceId;
    }

    public int getAttributeResourceValue(int resourceId, int defaultValue) {
        String attrName = this.resourceLoader.getResourceIndex().getResourceName(resourceId);
        ResName resName = this.getAttrResName(null, attrName);
        Attribute attr = this.findByName(resName);
        if (attr == null) {
            return defaultValue;
        }
        Integer extracted = ResName.getResourceId(this.resourceLoader.getResourceIndex(), attr.value, attr.contextPackageName);
        return extracted == null ? defaultValue : extracted;
    }

    public int getAttributeIntValue(int index, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public float getAttributeFloatValue(int index, float defaultValue) {
        throw new UnsupportedOperationException();
    }

    public String getIdAttribute() {
        throw new UnsupportedOperationException();
    }

    public String getClassAttribute() {
        throw new UnsupportedOperationException();
    }

    public int getIdAttributeResourceValue(int defaultValue) {
        throw new UnsupportedOperationException();
    }

    public int getStyleAttribute() {
        Attribute styleAttribute = Attribute.find(this.attributes, new ResName("", "attr", "style"));
        if (styleAttribute == null) {
            return 0;
        }
        Integer i = ResName.getResourceId(this.resourceLoader.getResourceIndex(), styleAttribute.value, styleAttribute.contextPackageName);
        return i != null ? i : 0;
    }

    private ResName getAttrResName(String namespace, String attrName) {
        String packageName = Attribute.extractPackageName(namespace);
        return new ResName(packageName, "attr", attrName);
    }

    private Attribute findByName(ResName resName) {
        ResourceIndex resourceIndex = this.resourceLoader.getResourceIndex();
        Integer resourceId = resourceIndex.getResourceId(resName);
        if (resourceId == null) {
            return Attribute.find(this.attributes, resName);
        }
        return Attribute.find(this.attributes, resourceId, resourceIndex);
    }
}

