/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ShadowInvalidator;

public class RobolectricInternals {
    private static ClassHandler classHandler;
    private static ShadowInvalidator shadowInvalidator;
    private static ClassLoader classLoader;

    public static void classInitializing(Class<?> clazz) {
        classHandler.classInitializing(clazz);
    }

    public static MethodHandle getShadowCreator(Class<?> caller) {
        return classHandler.getShadowCreator(caller);
    }

    public static MethodHandle findShadowMethodHandle(Class<?> theClass, String name, MethodType methodType, boolean isStatic, boolean isNative) throws IllegalAccessException {
        return classHandler.findShadowMethodHandle(theClass, name, methodType, isStatic, isNative);
    }

    public static Throwable cleanStackTrace(Throwable exception) {
        return classHandler.stripStackTrace(exception);
    }

    public static Object intercept(String signature, Object instance, Object[] params, Class<?> theClass) throws Throwable {
        try {
            return classHandler.intercept(signature, instance, params, theClass);
        }
        catch (LinkageError e) {
            throw new Exception(e);
        }
    }

    public static void performStaticInitialization(Class<?> clazz) throws InvocationTargetException, IllegalAccessException {
        try {
            Method clinitMethod = clazz.getDeclaredMethod("__staticInitializer__", new Class[0]);
            clinitMethod.setAccessible(true);
            clinitMethod.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(clazz + " not instrumented?", e);
        }
    }

    public static ShadowInvalidator getShadowInvalidator() {
        return shadowInvalidator;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }
}

