/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.Objects;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.ShadowPicker;

public class ShadowInfo {
    public final String shadowedClassName;
    public final String shadowClassName;
    public final boolean callThroughByDefault;
    public final boolean callNativeMethodsByDefault;
    public final boolean looseSignatures;
    private final int minSdk;
    private final int maxSdk;
    private final Class<? extends ShadowPicker<?>> shadowPickerClass;

    ShadowInfo(String shadowedClassName, String shadowClassName, boolean callThroughByDefault, boolean callNativeMethodsByDefault, boolean looseSignatures, int minSdk, int maxSdk, Class<? extends ShadowPicker<?>> shadowPickerClass) {
        this.shadowedClassName = shadowedClassName;
        this.shadowClassName = shadowClassName;
        this.callThroughByDefault = callThroughByDefault;
        this.callNativeMethodsByDefault = callNativeMethodsByDefault;
        this.looseSignatures = looseSignatures;
        this.minSdk = minSdk;
        this.maxSdk = maxSdk;
        this.shadowPickerClass = Implements.DefaultShadowPicker.class.equals(shadowPickerClass) ? null : shadowPickerClass;
    }

    ShadowInfo(String shadowedClassName, String shadowClassName, Implements annotation) {
        this(shadowedClassName, shadowClassName, annotation.callThroughByDefault(), annotation.callNativeMethodsByDefault(), annotation.looseSignatures(), annotation.minSdk(), annotation.maxSdk(), annotation.shadowPicker());
    }

    public boolean supportsSdk(int sdkInt) {
        return this.minSdk <= sdkInt && (this.maxSdk == -1 || this.maxSdk >= sdkInt);
    }

    public boolean isShadowOf(Class<?> clazz) {
        return this.shadowedClassName.equals(clazz.getName());
    }

    public boolean hasShadowPicker() {
        return this.shadowPickerClass != null && !Implements.DefaultShadowPicker.class.equals(this.shadowPickerClass);
    }

    public Class<? extends ShadowPicker<?>> getShadowPickerClass() {
        return this.shadowPickerClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShadowInfo)) {
            return false;
        }
        ShadowInfo that = (ShadowInfo)o;
        return this.callThroughByDefault == that.callThroughByDefault && this.looseSignatures == that.looseSignatures && this.minSdk == that.minSdk && this.maxSdk == that.maxSdk && Objects.equals(this.shadowedClassName, that.shadowedClassName) && Objects.equals(this.shadowClassName, that.shadowClassName) && Objects.equals(this.shadowPickerClass, that.shadowPickerClass);
    }

    public int hashCode() {
        return Objects.hash(this.shadowedClassName, this.shadowClassName, this.callThroughByDefault, this.looseSignatures, this.minSdk, this.maxSdk, this.shadowPickerClass);
    }
}

