/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implements;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.sandbox.ShadowMatcher;
import org.robolectric.shadow.api.ShadowPicker;
import org.robolectric.util.Logger;

public class ShadowMap {
    static final ShadowMap EMPTY = new ShadowMap((ImmutableListMultimap<String, String>)ImmutableListMultimap.of(), (Map<String, ShadowInfo>)ImmutableMap.of());
    private final ImmutableListMultimap<String, String> defaultShadows;
    private final ImmutableMap<String, ShadowInfo> overriddenShadows;
    private final ImmutableMap<String, String> shadowPickers;

    public static ShadowMap createFromShadowProviders(List<ShadowProvider> sortedProviders) {
        ArrayListMultimap shadowMap = ArrayListMultimap.create();
        HashMap shadowPickerMap = new HashMap();
        for (ShadowProvider provider : sortedProviders) {
            Logger.debug((String)("Shadow provider: " + provider.getClass().getName()), (Object[])new Object[0]);
            for (Map.Entry entry : provider.getShadows()) {
                shadowMap.put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            provider.getShadowPickerMap().forEach(shadowPickerMap::putIfAbsent);
        }
        return new ShadowMap((ImmutableListMultimap<String, String>)ImmutableListMultimap.copyOf((Multimap)shadowMap), Collections.emptyMap(), (Map<String, String>)ImmutableMap.copyOf(shadowPickerMap));
    }

    ShadowMap(ImmutableListMultimap<String, String> defaultShadows, Map<String, ShadowInfo> overriddenShadows) {
        this(defaultShadows, overriddenShadows, Collections.emptyMap());
    }

    private ShadowMap(ImmutableListMultimap<String, String> defaultShadows, Map<String, ShadowInfo> overriddenShadows, Map<String, String> shadowPickers) {
        this.defaultShadows = ImmutableListMultimap.copyOf(defaultShadows);
        this.overriddenShadows = ImmutableMap.copyOf(overriddenShadows);
        this.shadowPickers = ImmutableMap.copyOf(shadowPickers);
    }

    public boolean hasShadowPicker(MutableClass mutableClass) {
        return this.shadowPickers.containsKey((Object)mutableClass.getName());
    }

    public ShadowInfo getShadowInfo(Class<?> clazz, ShadowMatcher shadowMatcher) {
        String instrumentedClassName = clazz.getName();
        ShadowInfo shadowInfo = (ShadowInfo)this.overriddenShadows.get((Object)instrumentedClassName);
        String shadowPickerClassName = null;
        if (shadowInfo != null && shadowInfo.hasShadowPicker()) {
            shadowPickerClassName = shadowInfo.getShadowPickerClass().getName();
        } else if (shadowInfo == null) {
            shadowPickerClassName = (String)this.shadowPickers.get((Object)instrumentedClassName);
        }
        if (shadowPickerClassName != null) {
            shadowInfo = this.pickShadow(instrumentedClassName, clazz, shadowPickerClassName);
        } else if (shadowInfo == null) {
            try {
                ImmutableList shadowNames = this.defaultShadows.get((Object)clazz.getCanonicalName());
                for (String shadowName : shadowNames) {
                    if (shadowName == null) continue;
                    Class<?> shadowClass = clazz.getClassLoader().loadClass(shadowName);
                    shadowInfo = ShadowMap.obtainShadowInfo(shadowClass);
                    if (!shadowInfo.shadowedClassName.equals(instrumentedClassName)) {
                        shadowInfo = null;
                    }
                    if (shadowInfo == null || !shadowMatcher.matches(shadowInfo)) continue;
                    return shadowInfo;
                }
            }
            catch (ClassNotFoundException | IncompatibleClassChangeError e) {
                return null;
            }
        }
        if (shadowInfo != null && !shadowMatcher.matches(shadowInfo)) {
            return null;
        }
        return shadowInfo;
    }

    private ShadowInfo pickShadow(String instrumentedClassName, Class<?> clazz, String shadowPickerClassName) {
        ClassLoader sandboxClassLoader = clazz.getClassLoader();
        try {
            Class<?> shadowPickerClass = sandboxClassLoader.loadClass(shadowPickerClassName);
            ShadowPicker shadowPicker = (ShadowPicker)shadowPickerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class selectedShadowClass = shadowPicker.pickShadowClass();
            if (selectedShadowClass == null) {
                return ShadowMap.obtainShadowInfo(Object.class, true);
            }
            ShadowInfo shadowInfo = ShadowMap.obtainShadowInfo(selectedShadowClass);
            if (!shadowInfo.shadowedClassName.equals(instrumentedClassName)) {
                throw new IllegalArgumentException("Implemented class for " + selectedShadowClass.getName() + " (" + shadowInfo.shadowedClassName + ") != " + instrumentedClassName);
            }
            return shadowInfo;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to resolve shadow picker for " + instrumentedClassName, e);
        }
    }

    public static ShadowInfo obtainShadowInfo(Class<?> clazz) {
        return ShadowMap.obtainShadowInfo(clazz, false);
    }

    static ShadowInfo obtainShadowInfo(Class<?> clazz, boolean mayBeNonShadow) {
        Implements annotation = clazz.getAnnotation(Implements.class);
        if (annotation == null) {
            if (mayBeNonShadow) {
                return null;
            }
            throw new IllegalArgumentException(clazz + " is not annotated with @Implements");
        }
        String className = annotation.className();
        if (className.isEmpty()) {
            className = annotation.value().getName();
        }
        return new ShadowInfo(className, clazz.getName(), annotation);
    }

    public Set<String> getInvalidatedClasses(ShadowMap previous) {
        if (this == previous && this.shadowPickers.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<String, ShadowInfo> invalidated = new HashMap<String, ShadowInfo>((Map<String, ShadowInfo>)this.overriddenShadows);
        for (Map.Entry entry : previous.overriddenShadows.entrySet()) {
            String className = (String)entry.getKey();
            ShadowInfo previousConfig = (ShadowInfo)entry.getValue();
            ShadowInfo currentConfig = (ShadowInfo)invalidated.get(className);
            if (currentConfig == null) {
                invalidated.put(className, previousConfig);
                continue;
            }
            if (!previousConfig.equals(currentConfig)) continue;
            invalidated.remove(className);
        }
        return invalidated.keySet();
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShadowMap)) {
            return false;
        }
        ShadowMap shadowMap = (ShadowMap)o;
        return this.overriddenShadows.equals(shadowMap.overriddenShadows);
    }

    public int hashCode() {
        return this.overriddenShadows.hashCode();
    }

    public static class Builder {
        private final ImmutableListMultimap<String, String> defaultShadows;
        private final Map<String, ShadowInfo> overriddenShadows;
        private final Map<String, String> shadowPickers;

        public Builder() {
            this.defaultShadows = ImmutableListMultimap.of();
            this.overriddenShadows = new HashMap<String, ShadowInfo>();
            this.shadowPickers = new HashMap<String, String>();
        }

        public Builder(ShadowMap shadowMap) {
            this.defaultShadows = shadowMap.defaultShadows;
            this.overriddenShadows = new HashMap<String, ShadowInfo>((Map<String, ShadowInfo>)shadowMap.overriddenShadows);
            this.shadowPickers = new HashMap<String, String>((Map<String, String>)shadowMap.shadowPickers);
        }

        public Builder addShadowClasses(Class<?> ... shadowClasses) {
            for (Class<?> shadowClass : shadowClasses) {
                this.addShadowClass(shadowClass);
            }
            return this;
        }

        Builder addShadowClass(Class<?> shadowClass) {
            this.addShadowInfo(ShadowMap.obtainShadowInfo(shadowClass));
            return this;
        }

        Builder addShadowClass(String realClassName, String shadowClassName, boolean callThroughByDefault, boolean callNativeMethodsByDefault, boolean looseSignatures) {
            this.addShadowInfo(new ShadowInfo(realClassName, shadowClassName, callThroughByDefault, callNativeMethodsByDefault, looseSignatures, -1, -1, null));
            return this;
        }

        private void addShadowInfo(ShadowInfo shadowInfo) {
            this.overriddenShadows.put(shadowInfo.shadowedClassName, shadowInfo);
            if (shadowInfo.hasShadowPicker()) {
                this.shadowPickers.put(shadowInfo.shadowedClassName, shadowInfo.getShadowPickerClass().getName());
            }
        }

        public ShadowMap build() {
            return new ShadowMap(this.defaultShadows, this.overriddenShadows, this.shadowPickers);
        }
    }
}

