/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ClassDetails {
    private static final String SHADOWED_OBJECT_INTERNAL_NAME = ShadowedObject.class.getName().replace('.', '/');
    private final ClassReader classReader;
    private final String className;
    private final byte[] classBytes;
    private Set<String> annotations;
    private Set<String> interfaces;

    public ClassDetails(byte[] classBytes) {
        this.classBytes = classBytes;
        this.classReader = new ClassReader(classBytes);
        this.className = this.classReader.getClassName().replace('/', '.');
    }

    public boolean isInterface() {
        return (this.classReader.getAccess() & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classReader.getAccess() & 0x2000) != 0;
    }

    public String getName() {
        return this.className;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
        if (this.annotations == null) {
            this.annotations = new HashSet<String>();
            this.classReader.accept((ClassVisitor)new AnnotationCollector(this.annotations), 7);
        }
        String string = annotationClass.getName().replace('.', '/');
        String internalName = new StringBuilder(2 + String.valueOf(string).length()).append("L").append(string).append(";").toString();
        return this.annotations.contains(internalName);
    }

    public boolean isInstrumented() {
        if (this.interfaces == null) {
            this.interfaces = new HashSet<String>(Arrays.asList(this.classReader.getInterfaces()));
        }
        return this.interfaces.contains(SHADOWED_OBJECT_INTERNAL_NAME);
    }

    public byte[] getClassBytes() {
        return this.classBytes;
    }

    private static class AnnotationCollector
    extends ClassVisitor {
        private final Set<String> annotations;

        public AnnotationCollector(Set<String> annotations) {
            super(589824);
            this.annotations = annotations;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (visible) {
                this.annotations.add(descriptor);
            }
            return null;
        }
    }
}

