/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.robolectric.internal.bytecode.ClassDetails;
import org.robolectric.internal.bytecode.ClassNodeProvider;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InstrumentingClassWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.MutableClass;
import org.robolectric.internal.bytecode.RobolectricGeneratorAdapter;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowDecorator;
import org.robolectric.internal.bytecode.ShadowImpl;
import org.robolectric.util.PerfStatsCollector;

public class ClassInstrumentor {
    private static final Handle BOOTSTRAP_INIT;
    private static final Handle BOOTSTRAP;
    private static final Handle BOOTSTRAP_STATIC;
    private static final Handle BOOTSTRAP_INTRINSIC;
    private static final String ROBO_INIT_METHOD_NAME = "$$robo$init";
    static final Type OBJECT_TYPE;
    private static final ShadowImpl SHADOW_IMPL;
    final Decorator decorator;

    public ClassInstrumentor() {
        this(new ShadowDecorator());
    }

    protected ClassInstrumentor(Decorator decorator) {
        this.decorator = decorator;
    }

    private MutableClass analyzeClass(byte[] origClassBytes, final InstrumentationConfiguration config, ClassNodeProvider classNodeProvider) {
        ClassNode classNode = new ClassNode(this, 262144){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, config.remapParams(desc), signature, exceptions);
                return new JSRInlinerAdapter(methodVisitor, access, name, desc, signature, exceptions);
            }
        };
        ClassReader classReader = new ClassReader(origClassBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return new MutableClass(classNode, config, classNodeProvider);
    }

    byte[] instrumentToBytes(final MutableClass mutableClass) {
        this.instrument(mutableClass);
        ClassNode classNode = mutableClass.classNode;
        InstrumentingClassWriter writer = new InstrumentingClassWriter(mutableClass.classNodeProvider, classNode);
        Remapper remapper = new Remapper(this){

            public String map(String internalName) {
                return mutableClass.config.mappedTypeName(internalName);
            }
        };
        ClassRemapper visitor = new ClassRemapper((ClassVisitor)writer, remapper);
        classNode.accept((ClassVisitor)visitor);
        return writer.toByteArray();
    }

    public byte[] instrument(ClassDetails classDetails, InstrumentationConfiguration config, ClassNodeProvider classNodeProvider) {
        PerfStatsCollector perfStats = PerfStatsCollector.getInstance();
        MutableClass mutableClass = (MutableClass)perfStats.measure("analyze class", () -> this.analyzeClass(classDetails.getClassBytes(), config, classNodeProvider));
        byte[] instrumentedBytes = (byte[])perfStats.measure("instrument class", () -> this.instrumentToBytes(mutableClass));
        this.recordPackageStats(perfStats, mutableClass);
        return instrumentedBytes;
    }

    private void recordPackageStats(PerfStatsCollector perfStats, MutableClass mutableClass) {
        String className = mutableClass.getName();
        int i = className.indexOf(46);
        while (i != -1) {
            perfStats.incrementCount("instrument package " + className.substring(0, i));
            i = className.indexOf(46, i + 1);
        }
    }

    public void instrument(MutableClass mutableClass) {
        try {
            mutableClass.classNode.version = Math.max(mutableClass.classNode.version, 51);
            if (mutableClass.getName().equals("android.util.SparseArray")) {
                this.addSetToSparseArray(mutableClass);
            }
            this.instrumentMethods(mutableClass);
            if (mutableClass.isInterface()) {
                mutableClass.addInterface(Type.getInternalName(InstrumentedInterface.class));
            } else {
                ClassInstrumentor.makeClassPublic(mutableClass.classNode);
                if ((mutableClass.classNode.access & 0x10) == 16) {
                    mutableClass.classNode.visitAnnotation("Lcom/google/errorprone/annotations/DoNotMock;", true).visit("value", (Object)"This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.");
                }
                mutableClass.classNode.access &= 0xFFFFFFEF;
                ClassInstrumentor.addNoArgsConstructor(mutableClass);
                this.addDirectCallConstructor(mutableClass);
                this.addRoboInitMethod(mutableClass);
                ClassInstrumentor.removeFinalFromFields(mutableClass);
                this.decorator.decorate(mutableClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to instrument " + mutableClass.getName(), e);
        }
    }

    private void addSetToSparseArray(MutableClass mutableClass) {
        for (MethodNode methodNode : mutableClass.getMethods()) {
            if (!"set".equals(methodNode.name)) continue;
            return;
        }
        MethodNode setFunction = new MethodNode(4097, "set", "(ILjava/lang/Object;)V", "(ITE;)V", null);
        RobolectricGeneratorAdapter robolectricGeneratorAdapter = new RobolectricGeneratorAdapter(setFunction);
        robolectricGeneratorAdapter.loadThis();
        robolectricGeneratorAdapter.loadArg(0);
        robolectricGeneratorAdapter.loadArg(1);
        robolectricGeneratorAdapter.invokeVirtual(mutableClass.classType, new Method("put", "(ILjava/lang/Object;)V"));
        robolectricGeneratorAdapter.returnValue();
        mutableClass.addMethod(setFunction);
    }

    private void instrumentMethods(MutableClass mutableClass) {
        if (mutableClass.isInterface()) {
            for (MethodNode methodNode : mutableClass.getMethods()) {
                this.rewriteMethodBody(mutableClass, methodNode);
            }
        } else {
            for (MethodNode methodNode : mutableClass.getMethods()) {
                this.rewriteMethodBody(mutableClass, methodNode);
                if (methodNode.name.equals("<clinit>")) {
                    methodNode.name = "__staticInitializer__";
                    mutableClass.addMethod(ClassInstrumentor.generateStaticInitializerNotifierMethod(mutableClass));
                    continue;
                }
                if (methodNode.name.equals("<init>")) {
                    this.instrumentConstructor(mutableClass, methodNode);
                    continue;
                }
                if (ClassInstrumentor.isSyntheticAccessorMethod(methodNode) || Modifier.isAbstract(methodNode.access)) continue;
                this.instrumentNormalMethod(mutableClass, methodNode);
            }
        }
    }

    private static void addNoArgsConstructor(MutableClass mutableClass) {
        if (!mutableClass.foundMethods.contains((Object)"<init>()V")) {
            MethodNode defaultConstructor = new MethodNode(4097, "<init>", "()V", "()V", null);
            RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(defaultConstructor);
            generator.loadThis();
            generator.visitMethodInsn(183, mutableClass.classNode.superName, "<init>", "()V", false);
            generator.loadThis();
            generator.invokeVirtual(mutableClass.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
            generator.returnValue();
            mutableClass.addMethod(defaultConstructor);
        }
    }

    protected void addDirectCallConstructor(MutableClass mutableClass) {
    }

    private void addRoboInitMethod(MutableClass mutableClass) {
        MethodNode initMethodNode = new MethodNode(4100, ROBO_INIT_METHOD_NAME, "()V", null, null);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
        Label alreadyInitialized = new Label();
        generator.loadThis();
        generator.getField(mutableClass.classType, "__robo_data__", OBJECT_TYPE);
        generator.ifNonNull(alreadyInitialized);
        generator.loadThis();
        generator.loadThis();
        this.writeCallToInitializing(mutableClass, generator);
        generator.putField(mutableClass.classType, "__robo_data__", OBJECT_TYPE);
        generator.mark(alreadyInitialized);
        generator.returnValue();
        mutableClass.addMethod(initMethodNode);
    }

    protected void writeCallToInitializing(MutableClass mutableClass, RobolectricGeneratorAdapter generator) {
        generator.invokeDynamic("initializing", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{mutableClass.classType}), BOOTSTRAP_INIT, new Object[0]);
    }

    private static void removeFinalFromFields(MutableClass mutableClass) {
        for (FieldNode fieldNode : mutableClass.getFields()) {
            fieldNode.access &= 0xFFFFFFEF;
        }
    }

    private static boolean isSyntheticAccessorMethod(MethodNode method) {
        return (method.access & 0x1000) != 0;
    }

    private void instrumentConstructor(MutableClass mutableClass, MethodNode method) {
        this.makeMethodPrivate(method);
        InsnList callSuper = ClassInstrumentor.extractCallToSuperConstructor(mutableClass, method);
        method.name = ClassInstrumentor.directMethodName(mutableClass, "__constructor__");
        mutableClass.addMethod(this.redirectorMethod(mutableClass, method, "__constructor__"));
        String[] exceptions = this.exceptionArray(method);
        MethodNode initMethodNode = new MethodNode(method.access, "<init>", method.desc, method.signature, exceptions);
        this.makeMethodPublic(initMethodNode);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(initMethodNode);
        initMethodNode.instructions = callSuper;
        generator.loadThis();
        generator.invokeVirtual(mutableClass.classType, new Method(ROBO_INIT_METHOD_NAME, "()V"));
        this.generateClassHandlerCall(mutableClass, method, "__constructor__", generator);
        generator.endMethod();
        mutableClass.addMethod(initMethodNode);
    }

    private static InsnList extractCallToSuperConstructor(MutableClass mutableClass, MethodNode ctor) {
        InsnList removedInstructions = new InsnList();
        int startIndex = 0;
        AbstractInsnNode[] insns = ctor.instructions.toArray();
        block6: for (int i = 0; i < insns.length; ++i) {
            AbstractInsnNode node = insns[i];
            switch (node.getOpcode()) {
                case 25: {
                    VarInsnNode vnode = (VarInsnNode)node;
                    if (vnode.var != 0) continue block6;
                    startIndex = i;
                    continue block6;
                }
                case 181: {
                    FieldInsnNode pnode = (FieldInsnNode)node;
                    if (!pnode.owner.equals(mutableClass.internalClassName) || !pnode.name.equals("this$0")) continue block6;
                    while (startIndex <= i) {
                        ctor.instructions.remove(insns[startIndex]);
                        removedInstructions.add(insns[startIndex]);
                        ++startIndex;
                    }
                    continue block6;
                }
                case 183: {
                    MethodInsnNode mnode = (MethodInsnNode)node;
                    if (!mnode.owner.equals(mutableClass.internalClassName) && !mnode.owner.equals(mutableClass.classNode.superName)) continue block6;
                    if (!"<init>".equals(mnode.name)) {
                        throw new AssertionError((Object)"Invalid MethodInsnNode name");
                    }
                    while (startIndex <= i) {
                        ctor.instructions.remove(insns[startIndex]);
                        removedInstructions.add(insns[startIndex]);
                        ++startIndex;
                    }
                    return removedInstructions;
                }
                case 191: {
                    ctor.visitCode();
                    ctor.visitInsn(177);
                    ctor.visitEnd();
                    return removedInstructions;
                }
            }
        }
        throw new RuntimeException("huh? " + ctor.name + ctor.desc);
    }

    protected void instrumentNormalMethod(MutableClass mutableClass, MethodNode method) {
        boolean isNativeMethod;
        if ((method.access & 0x400) == 0) {
            method.access |= 0x10;
        }
        boolean bl = isNativeMethod = (method.access & 0x100) != 0;
        if (isNativeMethod) {
            this.instrumentNativeMethod(mutableClass, method);
        }
        String originalName = method.name;
        method.name = ClassInstrumentor.directMethodName(mutableClass, originalName);
        MethodNode delegatorMethodNode = new MethodNode(method.access, originalName, method.desc, method.signature, this.exceptionArray(method));
        delegatorMethodNode.visibleAnnotations = method.visibleAnnotations;
        delegatorMethodNode.access &= 0xFFFFFAEF;
        this.makeMethodPrivate(method);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(delegatorMethodNode);
        this.generateClassHandlerCall(mutableClass, method, originalName, generator);
        generator.endMethod();
        mutableClass.addMethod(delegatorMethodNode);
    }

    protected void instrumentNativeMethod(MutableClass mutableClass, MethodNode method) {
        method.access &= 0xFFFFFEFF;
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(method);
        Type returnType = generator.getReturnType();
        generator.pushDefaultReturnValueToStack(returnType);
        generator.returnValue();
    }

    protected static String directMethodName(MutableClass mutableClass, String originalName) {
        return SHADOW_IMPL.directMethodName(mutableClass.getName(), originalName);
    }

    private MethodNode redirectorMethod(MutableClass mutableClass, MethodNode method, String newName) {
        MethodNode redirector = new MethodNode(262144, newName, method.desc, method.signature, this.exceptionArray(method));
        redirector.access = method.access & 0xFFFFFAEF;
        this.makeMethodPrivate(redirector);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(redirector);
        generator.invokeMethod(mutableClass.internalClassName, method);
        generator.returnValue();
        return redirector;
    }

    protected String[] exceptionArray(MethodNode method) {
        List exceptions = method.exceptions;
        return exceptions.toArray(new String[exceptions.size()]);
    }

    private void rewriteMethodBody(MutableClass mutableClass, MethodNode callingMethod) {
        ListIterator instructions = callingMethod.instructions.iterator();
        while (instructions.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)instructions.next();
            switch (node.getOpcode()) {
                case 187: {
                    TypeInsnNode newInsnNode = (TypeInsnNode)node;
                    newInsnNode.desc = mutableClass.config.mappedTypeName(newInsnNode.desc);
                    break;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                    fieldInsnNode.desc = mutableClass.config.mappedTypeName(fieldInsnNode.desc);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    MethodInsnNode targetMethod = (MethodInsnNode)node;
                    targetMethod.desc = mutableClass.config.remapParams(targetMethod.desc);
                    if (ClassInstrumentor.isGregorianCalendarBooleanConstructor(targetMethod)) {
                        ClassInstrumentor.replaceGregorianCalendarBooleanConstructor(instructions, targetMethod);
                        break;
                    }
                    if (!mutableClass.config.shouldIntercept(targetMethod)) break;
                    this.interceptInvokeVirtualMethod(mutableClass, instructions, targetMethod);
                    break;
                }
                case 186: {
                    break;
                }
            }
        }
    }

    private static boolean isGregorianCalendarBooleanConstructor(MethodInsnNode targetMethod) {
        return targetMethod.owner.equals("java/util/GregorianCalendar") && targetMethod.name.equals("<init>") && targetMethod.desc.equals("(Z)V");
    }

    private static void replaceGregorianCalendarBooleanConstructor(ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        instructions.remove();
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new InsnNode(3));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, targetMethod.owner, targetMethod.name, "(III)V", targetMethod.itf));
    }

    protected void interceptInvokeVirtualMethod(MutableClass mutableClass, ListIterator<AbstractInsnNode> instructions, MethodInsnNode targetMethod) {
        instructions.remove();
        Type type = Type.getObjectType((String)targetMethod.owner);
        String description = targetMethod.desc;
        String owner = type.getClassName();
        if (targetMethod.getOpcode() != 184) {
            String thisType = type.getDescriptor();
            description = "(" + thisType + description.substring(1);
        }
        instructions.add((AbstractInsnNode)new InvokeDynamicInsnNode(targetMethod.name, description, BOOTSTRAP_INTRINSIC, new Object[]{owner}));
    }

    private static void makeClassPublic(ClassNode clazz) {
        clazz.access = (clazz.access | 1) & 0xFFFFFFF9;
    }

    protected void makeMethodPublic(MethodNode method) {
        method.access = (method.access | 1) & 0xFFFFFFF9;
    }

    protected void makeMethodPrivate(MethodNode method) {
        method.access = (method.access | 2) & 0xFFFFFFFA;
    }

    private static MethodNode generateStaticInitializerNotifierMethod(MutableClass mutableClass) {
        MethodNode methodNode = new MethodNode(8, "<clinit>", "()V", "()V", null);
        RobolectricGeneratorAdapter generator = new RobolectricGeneratorAdapter(methodNode);
        generator.push(mutableClass.classType);
        generator.invokeStatic(Type.getType(RobolectricInternals.class), new Method("classInitializing", "(Ljava/lang/Class;)V"));
        generator.returnValue();
        generator.endMethod();
        return methodNode;
    }

    protected void generateClassHandlerCall(MutableClass mutableClass, MethodNode originalMethod, String originalMethodName, RobolectricGeneratorAdapter generator) {
        Handle original = new Handle(this.getTag(originalMethod), mutableClass.classType.getInternalName(), originalMethod.name, originalMethod.desc, this.getTag(originalMethod) == 9);
        if (generator.isStatic()) {
            generator.loadArgs();
            generator.invokeDynamic(originalMethodName, originalMethod.desc, BOOTSTRAP_STATIC, new Object[]{original});
        } else {
            String desc = "(" + mutableClass.classType.getDescriptor() + originalMethod.desc.substring(1);
            generator.loadThis();
            generator.loadArgs();
            generator.invokeDynamic(originalMethodName, desc, BOOTSTRAP, new Object[]{original});
        }
        generator.returnValue();
    }

    int getTag(MethodNode m) {
        return Modifier.isStatic(m.access) ? 6 : 7;
    }

    static {
        OBJECT_TYPE = Type.getType(Object.class);
        SHADOW_IMPL = new ShadowImpl();
        String className = Type.getInternalName(InvokeDynamicSupport.class);
        MethodType bootstrap = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
        String bootstrapMethod = bootstrap.appendParameterTypes(MethodHandle.class).toMethodDescriptorString();
        String bootstrapIntrinsic = bootstrap.appendParameterTypes(String.class).toMethodDescriptorString();
        BOOTSTRAP_INIT = new Handle(6, className, "bootstrapInit", bootstrap.toMethodDescriptorString(), false);
        BOOTSTRAP = new Handle(6, className, "bootstrap", bootstrapMethod, false);
        BOOTSTRAP_STATIC = new Handle(6, className, "bootstrapStatic", bootstrapMethod, false);
        BOOTSTRAP_INTRINSIC = new Handle(6, className, "bootstrapIntrinsic", bootstrapIntrinsic, false);
    }

    static class TryCatch {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final GeneratorAdapter generatorAdapter;

        TryCatch(GeneratorAdapter generatorAdapter, Type type) {
            this.generatorAdapter = generatorAdapter;
            this.start = generatorAdapter.mark();
            this.end = new Label();
            this.handler = new Label();
            generatorAdapter.visitTryCatchBlock(this.start, this.end, this.handler, type.getInternalName());
        }

        void end() {
            this.generatorAdapter.mark(this.end);
        }

        void handler() {
            this.generatorAdapter.mark(this.handler);
        }
    }

    public static interface Decorator {
        public void decorate(MutableClass var1);
    }
}

