/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.robolectric.internal.bytecode.ClassValueMap;
import org.robolectric.util.PerfStatsCollector;
import sun.misc.Unsafe;

@Deprecated
public class ProxyMaker {
    private static final String TARGET_FIELD = "__proxy__";
    private static final Class UNSAFE_CLASS = Unsafe.class;
    private static final Class LOOKUP_CLASS = MethodHandles.Lookup.class;
    private static final Unsafe UNSAFE;
    private static final java.lang.reflect.Method DEFINE_ANONYMOUS_CLASS;
    private static final MethodHandles.Lookup LOOKUP;
    private static final java.lang.reflect.Method HIDDEN_DEFINE_METHOD;
    private static final Object HIDDEN_CLASS_OPTIONS;
    private static final boolean DEBUG = false;
    private final MethodMapper methodMapper;
    private final ClassValueMap<Factory> factories;

    private static java.lang.reflect.Method getDefineAnonymousClass() {
        try {
            return UNSAFE_CLASS.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static MethodHandles.Lookup getTrustedLookup() throws ReflectiveOperationException {
        Field trustedLookupField = LOOKUP_CLASS.getDeclaredField("IMPL_LOOKUP");
        java.lang.reflect.Method baseMethod = UNSAFE_CLASS.getMethod("staticFieldBase", Field.class);
        Object lookupBase = baseMethod.invoke((Object)UNSAFE, trustedLookupField);
        java.lang.reflect.Method offsetMethod = UNSAFE_CLASS.getMethod("staticFieldOffset", Field.class);
        Object lookupOffset = offsetMethod.invoke((Object)UNSAFE, trustedLookupField);
        java.lang.reflect.Method getObjectMethod = UNSAFE_CLASS.getMethod("getObject", Object.class, Long.TYPE);
        return (MethodHandles.Lookup)getObjectMethod.invoke((Object)UNSAFE, lookupBase, lookupOffset);
    }

    public ProxyMaker(MethodMapper methodMapper) {
        this.methodMapper = methodMapper;
        this.factories = new ClassValueMap<Factory>(){

            @Override
            protected Factory computeValue(Class<?> type) {
                return (Factory)PerfStatsCollector.getInstance().measure("createProxyFactory", () -> ProxyMaker.this.createProxyFactory(type));
            }
        };
    }

    public <T> T createProxy(Class<T> targetClass, T target) {
        return (T)PerfStatsCollector.getInstance().measure("createProxyInstance", () -> this.factories.get(targetClass).createProxy(targetClass, target));
    }

    <T> Factory createProxyFactory(Class<T> targetClass) {
        Type targetType = Type.getType(targetClass);
        String targetName = targetType.getInternalName();
        String proxyName = targetName + "$GeneratedProxy";
        Type proxyType = Type.getType((String)("L" + proxyName.replace('.', '/') + ";"));
        ClassWriter writer = new ClassWriter(3);
        writer.visit(51, 4145, proxyName, null, targetName, null);
        writer.visitField(4097, TARGET_FIELD, targetType.getDescriptor(), null, null);
        for (java.lang.reflect.Method method : targetClass.getMethods()) {
            if (!ProxyMaker.shouldProxy(method)) continue;
            Method proxyMethod = Method.getMethod((java.lang.reflect.Method)method);
            GeneratorAdapter m = new GeneratorAdapter(4097, Method.getMethod((java.lang.reflect.Method)method), null, null, (ClassVisitor)writer);
            m.loadThis();
            m.getField(proxyType, TARGET_FIELD, targetType);
            m.loadArgs();
            String targetMethod = this.methodMapper.getName(targetClass.getName(), method.getName());
            m.visitMethodInsn(182, targetName, targetMethod, proxyMethod.getDescriptor(), false);
            m.returnValue();
            m.endMethod();
        }
        writer.visitEnd();
        byte[] bytecode = writer.toByteArray();
        try {
            final Class<?> proxyClass = ProxyMaker.defineHiddenClass(targetClass, bytecode);
            final Field field = proxyClass.getDeclaredField(TARGET_FIELD);
            return new Factory(this){

                public <E> E createProxy(Class<E> targetClass, E target) {
                    try {
                        Object proxy = UNSAFE.allocateInstance(proxyClass);
                        field.set(proxy, target);
                        return targetClass.cast(proxy);
                    }
                    catch (Throwable t) {
                        throw new AssertionError((Object)t);
                    }
                }
            };
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Class<?> defineHiddenClass(Class<?> targetClass, byte[] bytes) throws ReflectiveOperationException {
        if (DEFINE_ANONYMOUS_CLASS != null) {
            return (Class)DEFINE_ANONYMOUS_CLASS.invoke((Object)UNSAFE, targetClass, bytes, null);
        }
        MethodHandles.Lookup lookup = LOOKUP.in(targetClass);
        MethodHandles.Lookup definedLookup = (MethodHandles.Lookup)HIDDEN_DEFINE_METHOD.invoke((Object)lookup, bytes, false, HIDDEN_CLASS_OPTIONS);
        return definedLookup.lookupClass();
    }

    private static boolean shouldProxy(java.lang.reflect.Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isNative(modifiers);
    }

    static {
        try {
            Field unsafeField = UNSAFE_CLASS.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
            DEFINE_ANONYMOUS_CLASS = ProxyMaker.getDefineAnonymousClass();
            if (DEFINE_ANONYMOUS_CLASS == null) {
                LOOKUP = ProxyMaker.getTrustedLookup();
                Class<?> classOptionClass = Class.forName(LOOKUP_CLASS.getName() + "$ClassOption");
                HIDDEN_CLASS_OPTIONS = Array.newInstance(classOptionClass, 1);
                Array.set(HIDDEN_CLASS_OPTIONS, 0, Enum.valueOf(classOptionClass, "NESTMATE"));
                HIDDEN_DEFINE_METHOD = LOOKUP_CLASS.getMethod("defineHiddenClass", byte[].class, Boolean.TYPE, HIDDEN_CLASS_OPTIONS.getClass());
            } else {
                LOOKUP = null;
                HIDDEN_DEFINE_METHOD = null;
                HIDDEN_CLASS_OPTIONS = null;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    static interface Factory {
        public <T> T createProxy(Class<T> var1, T var2);
    }

    static interface MethodMapper {
        public String getName(String var1, String var2);
    }
}

