/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Rect;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.internal.ShadowExtractor;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityWindowInfo.class, minSdk=21)
public class ShadowAccessibilityWindowInfo {
    private static final Map<StrictEqualityWindowWrapper, StackTraceElement[]> obtainedInstances = new HashMap<StrictEqualityWindowWrapper, StackTraceElement[]>();
    private List<AccessibilityWindowInfo> children = null;
    private AccessibilityWindowInfo parent = null;
    private AccessibilityNodeInfo rootNode = null;
    private Rect boundsInScreen = new Rect();
    private int type = 1;
    private int layer = 0;
    private int id = 0;
    private boolean isAccessibilityFocused = false;
    private boolean isActive = false;
    private boolean isFocused = false;
    @RealObject
    private AccessibilityWindowInfo mRealAccessibilityWindowInfo;

    public void __constructor__() {
    }

    @Implementation
    public static AccessibilityWindowInfo obtain() {
        AccessibilityWindowInfo obtainedInstance = (AccessibilityWindowInfo)ReflectionHelpers.callConstructor(AccessibilityWindowInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        StrictEqualityWindowWrapper wrapper = new StrictEqualityWindowWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        return obtainedInstance;
    }

    @Implementation
    public static AccessibilityWindowInfo obtain(AccessibilityWindowInfo window) {
        ShadowAccessibilityWindowInfo shadowInfo = (ShadowAccessibilityWindowInfo)ShadowExtractor.extract((Object)window);
        AccessibilityWindowInfo obtainedInstance = shadowInfo.getClone();
        StrictEqualityWindowWrapper wrapper = new StrictEqualityWindowWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        return obtainedInstance;
    }

    private AccessibilityWindowInfo getClone() {
        AccessibilityWindowInfo newInfo = (AccessibilityWindowInfo)ReflectionHelpers.callConstructor(AccessibilityWindowInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityWindowInfo newShadow = (ShadowAccessibilityWindowInfo)ShadowExtractor.extract((Object)newInfo);
        newShadow.boundsInScreen = new Rect(this.boundsInScreen);
        newShadow.parent = this.parent;
        newShadow.rootNode = this.rootNode;
        newShadow.type = this.type;
        newShadow.layer = this.layer;
        newShadow.id = this.id;
        newShadow.isAccessibilityFocused = this.isAccessibilityFocused;
        newShadow.isActive = this.isActive;
        newShadow.isFocused = this.isFocused;
        return newInfo;
    }

    public static void resetObtainedInstances() {
        obtainedInstances.clear();
    }

    public static boolean areThereUnrecycledWindows(boolean printUnrecycledWindowsToSystemErr) {
        if (printUnrecycledWindowsToSystemErr) {
            for (StrictEqualityWindowWrapper wrapper : obtainedInstances.keySet()) {
                ShadowAccessibilityWindowInfo shadow = (ShadowAccessibilityWindowInfo)ShadowExtractor.extract((Object)wrapper.mInfo);
                System.err.println(String.format("Leaked type = %d, id = %d. Stack trace:", shadow.getType(), shadow.getId()));
                for (StackTraceElement stackTraceElement : obtainedInstances.get(wrapper)) {
                    System.err.println(stackTraceElement.toString());
                }
            }
        }
        return obtainedInstances.size() != 0;
    }

    @Implementation
    public boolean equals(Object object) {
        if (!(object instanceof AccessibilityWindowInfo)) {
            return false;
        }
        AccessibilityWindowInfo window = (AccessibilityWindowInfo)object;
        ShadowAccessibilityWindowInfo otherShadow = (ShadowAccessibilityWindowInfo)ShadowExtractor.extract((Object)window);
        boolean areEqual = this.type == otherShadow.getType();
        areEqual &= this.parent == otherShadow.getParent();
        areEqual &= this.rootNode == otherShadow.getRoot();
        areEqual &= this.layer == otherShadow.getLayer();
        areEqual &= this.id == otherShadow.getId();
        areEqual &= this.isAccessibilityFocused == otherShadow.isAccessibilityFocused();
        areEqual &= this.isActive == otherShadow.isActive();
        areEqual &= this.isFocused == otherShadow.isFocused();
        Rect anotherBounds = new Rect();
        otherShadow.getBoundsInScreen(anotherBounds);
        return areEqual &= this.boundsInScreen.equals((Object)anotherBounds);
    }

    @Implementation
    public int hashCode() {
        return 0;
    }

    @Implementation
    public int getType() {
        return this.type;
    }

    @Implementation
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Implementation
    public AccessibilityWindowInfo getChild(int index) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(index);
    }

    @Implementation
    public AccessibilityWindowInfo getParent() {
        return this.parent;
    }

    @Implementation
    public AccessibilityNodeInfo getRoot() {
        return this.rootNode == null ? null : AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.rootNode);
    }

    @Implementation
    public boolean isActive() {
        return this.isActive;
    }

    @Implementation
    public int getId() {
        return this.id;
    }

    @Implementation
    public void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen == null) {
            outBounds.setEmpty();
        } else {
            outBounds.set(this.boundsInScreen);
        }
    }

    @Implementation
    public int getLayer() {
        return this.layer;
    }

    @Implementation
    public boolean isFocused() {
        return this.isFocused;
    }

    @Implementation
    public boolean isAccessibilityFocused() {
        return this.isAccessibilityFocused;
    }

    @Implementation
    public void recycle() {
    }

    public void setRoot(AccessibilityNodeInfo root) {
        this.rootNode = root;
    }

    public void setType(int value) {
        this.type = value;
    }

    public void setBoundsInScreen(Rect bounds) {
        this.boundsInScreen.set(bounds);
    }

    public void setAccessibilityFocused(boolean value) {
        this.isAccessibilityFocused = value;
    }

    public void setActive(boolean value) {
        this.isActive = value;
    }

    public void setId(int value) {
        this.id = value;
    }

    public void setLayer(int value) {
        this.layer = value;
    }

    public void setFocused(boolean focused) {
        this.isFocused = focused;
    }

    public void addChild(AccessibilityWindowInfo child) {
        if (this.children == null) {
            this.children = new LinkedList<AccessibilityWindowInfo>();
        }
        this.children.add(child);
        ((ShadowAccessibilityWindowInfo)ShadowExtractor.extract((Object)child)).parent = this.mRealAccessibilityWindowInfo;
    }

    private static class StrictEqualityWindowWrapper {
        public final AccessibilityWindowInfo mInfo;

        public StrictEqualityWindowWrapper(AccessibilityWindowInfo info) {
            this.mInfo = info;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            StrictEqualityWindowWrapper wrapper = (StrictEqualityWindowWrapper)object;
            return this.mInfo == wrapper.mInfo;
        }

        public int hashCode() {
            return this.mInfo.hashCode();
        }
    }
}

