/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    private List<ScheduledAlarm> scheduledAlarms = new ArrayList<ScheduledAlarm>();

    @Implementation
    public void set(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=19)
    public void setExact(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=19)
    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.internalSet(type, windowStartMillis, 0L, operation);
    }

    @Implementation(minSdk=23)
    public void setAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation(minSdk=23)
    public void setExactAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation);
    }

    @Implementation
    public void setRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, interval, operation);
    }

    @Implementation
    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.internalSet(type, triggerAtMillis, intervalMillis, operation);
    }

    private void internalSet(int type, long triggerAtTime, long interval, PendingIntent operation) {
        Intent intent = Shadows.shadowOf(operation).getSavedIntent();
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            Intent scheduledIntent = Shadows.shadowOf(scheduledAlarm.operation).getSavedIntent();
            if (!scheduledIntent.filterEquals(intent)) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, interval, operation));
    }

    public ScheduledAlarm getNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.remove(0);
    }

    public ScheduledAlarm peekNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.get(0);
    }

    public List<ScheduledAlarm> getScheduledAlarms() {
        return this.scheduledAlarms;
    }

    @Implementation
    public void cancel(PendingIntent pendingIntent) {
        Intent intentTypeToRemove = Shadows.shadowOf(pendingIntent).getSavedIntent();
        for (ScheduledAlarm scheduledAlarm : new ArrayList<ScheduledAlarm>(this.scheduledAlarms)) {
            Intent alarmIntent = Shadows.shadowOf(scheduledAlarm.operation).getSavedIntent();
            if (!intentTypeToRemove.filterEquals(alarmIntent)) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
        }
    }

    public class ScheduledAlarm {
        public int type;
        public long triggerAtTime;
        public long interval;
        public PendingIntent operation;

        public ScheduledAlarm(int type, long triggerAtTime, PendingIntent operation) {
            this(type, triggerAtTime, 0L, operation);
        }

        public ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation) {
            this.type = type;
            this.triggerAtTime = triggerAtTime;
            this.operation = operation;
            this.interval = interval;
        }
    }
}

