/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.OperationCanceledException;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowCursorWindow;
import org.robolectric.shadows.util.SQLiteLibraryLoader;

@Implements(value=SQLiteConnection.class, isInAndroidSdk=false)
public class ShadowSQLiteConnection {
    private static final String IN_MEMORY_PATH = ":memory:";
    private static final Connections CONNECTIONS = new Connections();
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    private static final int IGNORED_REINDEX_STMT = -2;
    private static boolean useInMemoryDatabase;

    private static com.almworks.sqlite4java.SQLiteConnection connection(long pointer) {
        return CONNECTIONS.getConnection(pointer);
    }

    private static SQLiteStatement stmt(long connectionPtr, long pointer) {
        return CONNECTIONS.getStatement(connectionPtr, pointer);
    }

    public static void setUseInMemoryDatabase(boolean value) {
        useInMemoryDatabase = value;
    }

    @Implementation
    public static Number nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        SQLiteLibraryLoader.load();
        return RuntimeEnvironment.castNativePtr(CONNECTIONS.open(path));
    }

    @Implementation(maxSdk=20)
    public static int nativePrepareStatement(int connectionPtr, String sql) {
        return (int)ShadowSQLiteConnection.nativePrepareStatement((long)connectionPtr, sql);
    }

    @Implementation(minSdk=21)
    public static long nativePrepareStatement(long connectionPtr, String sql) {
        String newSql = ShadowSQLiteConnection.convertSQLWithLocalizedUnicodeCollator(sql);
        return CONNECTIONS.prepareStatement(connectionPtr, newSql);
    }

    static String convertSQLWithLocalizedUnicodeCollator(String sql) {
        Matcher matcher = COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql);
        return matcher.replaceAll(" COLLATE NOCASE");
    }

    @Resetter
    public static void reset() {
        CONNECTIONS.reset();
        useInMemoryDatabase = false;
    }

    @Implementation(maxSdk=20)
    public static void nativeClose(int connectionPtr) {
        ShadowSQLiteConnection.nativeClose((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeClose(long connectionPtr) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeFinalizeStatement(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeFinalizeStatement((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        CONNECTIONS.finalizeStmt(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static int nativeGetParameterCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeGetParameterCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetParameterCount(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return 0;
        }
        return CONNECTIONS.execute("get parameters count in prepared statement", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.getBindParameterCount();
            }
        });
    }

    @Implementation(maxSdk=20)
    public static boolean nativeIsReadOnly(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeIsReadOnly((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static boolean nativeIsReadOnly(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return true;
        }
        return CONNECTIONS.execute("call isReadOnly", new Callable<Boolean>(){

            @Override
            public Boolean call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.isReadOnly();
            }
        });
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForLong(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForLong((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForLong(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for long", new Callable<Long>(){

            @Override
            public Long call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                if (!stmt.step()) {
                    throw new SQLiteException(101, "No rows returned from query");
                }
                return stmt.columnLong(0);
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeExecute(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeExecute((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeExecute(final long connectionPtr, final long statementPtr) {
        if (statementPtr == -2L) {
            return;
        }
        CONNECTIONS.execute("execute", new Callable<Object>(){

            @Override
            public Object call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static String nativeExecuteForString(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForString((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static String nativeExecuteForString(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for string", new Callable<String>(){

            @Override
            public String call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                if (!stmt.step()) {
                    throw new SQLiteException(101, "No rows returned from query");
                }
                return stmt.columnString(0);
            }
        });
    }

    @Implementation(maxSdk=20)
    public static int nativeGetColumnCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeGetColumnCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetColumnCount(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("get columns count", new Callable<Integer>(){

            @Override
            public Integer call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.columnCount();
            }
        });
    }

    @Implementation(maxSdk=20)
    public static String nativeGetColumnName(int connectionPtr, int statementPtr, int index) {
        return ShadowSQLiteConnection.nativeGetColumnName((long)connectionPtr, (long)statementPtr, index);
    }

    @Implementation(minSdk=21)
    public static String nativeGetColumnName(final long connectionPtr, final long statementPtr, final int index) {
        return CONNECTIONS.execute("get column name at index " + index, new Callable<String>(){

            @Override
            public String call() throws SQLiteException {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return stmt.getColumnName(index);
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeBindNull(int connectionPtr, int statementPtr, int index) {
        ShadowSQLiteConnection.nativeBindNull((long)connectionPtr, (long)statementPtr, index);
    }

    @Implementation(minSdk=21)
    public static void nativeBindNull(final long connectionPtr, final long statementPtr, final int index) {
        CONNECTIONS.execute("bind null at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bindNull(index);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeBindLong(int connectionPtr, int statementPtr, int index, long value) {
        ShadowSQLiteConnection.nativeBindLong((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindLong(final long connectionPtr, final long statementPtr, final int index, final long value) {
        CONNECTIONS.execute("bind long at index " + index + " with value " + value, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeBindDouble(int connectionPtr, int statementPtr, int index, double value) {
        ShadowSQLiteConnection.nativeBindDouble((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindDouble(final long connectionPtr, final long statementPtr, final int index, final double value) {
        CONNECTIONS.execute("bind double at index " + index + " with value " + value, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeBindString(int connectionPtr, int statementPtr, int index, String value) {
        ShadowSQLiteConnection.nativeBindString((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindString(final long connectionPtr, final long statementPtr, final int index, final String value) {
        CONNECTIONS.execute("bind string at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeBindBlob(int connectionPtr, int statementPtr, int index, byte[] value) {
        ShadowSQLiteConnection.nativeBindBlob((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindBlob(final long connectionPtr, final long statementPtr, final int index, final byte[] value) {
        CONNECTIONS.execute("bind blob at index " + index, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.bind(index, value);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeRegisterLocalizedCollators(int connectionPtr, String locale) {
        ShadowSQLiteConnection.nativeRegisterLocalizedCollators((long)connectionPtr, locale);
    }

    @Implementation(minSdk=21)
    public static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
    }

    @Implementation(maxSdk=20)
    public static int nativeExecuteForChangedRowCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForChangedRowCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeExecuteForChangedRowCount(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for changed row count", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return ShadowSQLiteConnection.connection(connectionPtr).getChanges();
            }
        });
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForLastInsertedRowId(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForLastInsertedRowId((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForLastInsertedRowId(final long connectionPtr, final long statementPtr) {
        return CONNECTIONS.execute("execute for last inserted row ID", new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.stepThrough();
                return ShadowSQLiteConnection.connection(connectionPtr).getLastInsertId();
            }
        });
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForCursorWindow(int connectionPtr, int statementPtr, int windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return ShadowSQLiteConnection.nativeExecuteForCursorWindow((long)connectionPtr, (long)statementPtr, (long)windowPtr, startPos, requiredPos, countAllRows);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForCursorWindow(final long connectionPtr, final long statementPtr, final long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return CONNECTIONS.execute("execute for cursor window", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                return ShadowCursorWindow.setData(windowPtr, stmt);
            }
        }).intValue();
    }

    @Implementation(maxSdk=20)
    public static void nativeResetStatementAndClearBindings(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeResetStatementAndClearBindings((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeResetStatementAndClearBindings(final long connectionPtr, final long statementPtr) {
        CONNECTIONS.execute("reset statement", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLiteStatement stmt = ShadowSQLiteConnection.stmt(connectionPtr, statementPtr);
                stmt.reset(true);
                return null;
            }
        });
    }

    @Implementation(maxSdk=20)
    public static void nativeCancel(int connectionPtr) {
        ShadowSQLiteConnection.nativeCancel((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeCancel(long connectionPtr) {
        CONNECTIONS.cancel(connectionPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeResetCancel(int connectionPtr, boolean cancelable) {
        ShadowSQLiteConnection.nativeResetCancel((long)connectionPtr, cancelable);
    }

    @Implementation(minSdk=21)
    public static void nativeResetCancel(long connectionPtr, boolean cancelable) {
    }

    @Implementation(maxSdk=20)
    public static void nativeRegisterCustomFunction(int connectionPtr, SQLiteCustomFunction function) {
        ShadowSQLiteConnection.nativeRegisterCustomFunction((long)connectionPtr, function);
    }

    @Implementation(minSdk=21)
    public static void nativeRegisterCustomFunction(long connectionPtr, SQLiteCustomFunction function) {
    }

    @Implementation(maxSdk=20)
    public static int nativeExecuteForBlobFileDescriptor(int connectionPtr, long statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForBlobFileDescriptor((long)connectionPtr, statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return -1;
    }

    @Implementation(maxSdk=20)
    public static int nativeGetDbLookaside(int connectionPtr) {
        return ShadowSQLiteConnection.nativeGetDbLookaside((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetDbLookaside(long connectionPtr) {
        return 0;
    }

    static class Connections {
        private final AtomicLong pointerCounter = new AtomicLong(0L);
        private final Map<Long, SQLiteStatement> statementsMap = new ConcurrentHashMap<Long, SQLiteStatement>();
        private final Map<Long, com.almworks.sqlite4java.SQLiteConnection> connectionsMap = new ConcurrentHashMap<Long, com.almworks.sqlite4java.SQLiteConnection>();
        private ExecutorService dbExecutor = Executors.newSingleThreadExecutor();

        Connections() {
        }

        public com.almworks.sqlite4java.SQLiteConnection getConnection(long pointer) {
            com.almworks.sqlite4java.SQLiteConnection connection = this.connectionsMap.get(pointer);
            if (connection == null) {
                throw new IllegalStateException("Illegal connection pointer " + pointer + ". Current pointers for thread " + Thread.currentThread() + " " + this.connectionsMap.keySet());
            }
            return connection;
        }

        public SQLiteStatement getStatement(long connectionPtr, long pointer) {
            this.getConnection(connectionPtr);
            SQLiteStatement stmt = this.statementsMap.get(pointer);
            if (stmt == null) {
                throw new IllegalArgumentException("Invalid prepared statement pointer: " + pointer + ". Current pointers: " + this.statementsMap.keySet());
            }
            if (stmt.isDisposed()) {
                throw new IllegalStateException("Statement " + pointer + " " + stmt + " is disposed");
            }
            return stmt;
        }

        public long open(final String path) {
            com.almworks.sqlite4java.SQLiteConnection dbConnection = this.execute("open SQLite connection", new Callable<com.almworks.sqlite4java.SQLiteConnection>(){

                @Override
                public com.almworks.sqlite4java.SQLiteConnection call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = useInMemoryDatabase || ShadowSQLiteConnection.IN_MEMORY_PATH.equals(path) ? new com.almworks.sqlite4java.SQLiteConnection() : new com.almworks.sqlite4java.SQLiteConnection(new File(path));
                    connection.open();
                    return connection;
                }
            });
            long ptr = this.pointerCounter.incrementAndGet();
            this.connectionsMap.put(ptr, dbConnection);
            return ptr;
        }

        public long prepareStatement(final long connectionPtr, final String sql) {
            if ("REINDEX LOCALIZED".equals(sql)) {
                return -2L;
            }
            SQLiteStatement stmt = this.execute("prepare statement", new Callable<SQLiteStatement>(){

                @Override
                public SQLiteStatement call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = Connections.this.getConnection(connectionPtr);
                    return connection.prepare(sql);
                }
            });
            long pointer = this.pointerCounter.incrementAndGet();
            this.statementsMap.put(pointer, stmt);
            return pointer;
        }

        public void close(final long ptr) {
            this.execute("close connection", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    com.almworks.sqlite4java.SQLiteConnection connection = Connections.this.getConnection(ptr);
                    connection.dispose();
                    return null;
                }
            });
        }

        public void reset() {
            for (long connectionPtr : this.connectionsMap.keySet()) {
                this.close(connectionPtr);
            }
            this.dbExecutor.shutdown();
            try {
                this.dbExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.dbExecutor = Executors.newSingleThreadExecutor();
            this.connectionsMap.clear();
            this.statementsMap.clear();
        }

        public void finalizeStmt(final long connectionPtr, final long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            this.execute("finalize statement", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SQLiteStatement stmt = Connections.this.getStatement(connectionPtr, statementPtr);
                    Connections.this.statementsMap.remove(statementPtr);
                    stmt.dispose();
                    return null;
                }
            });
        }

        public void cancel(long connectionPtr) {
            this.getConnection(connectionPtr);
            this.execute("cancel", new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SQLiteStatement statement = (SQLiteStatement)Connections.this.statementsMap.get(Connections.this.pointerCounter.get());
                    if (statement != null) {
                        statement.cancel();
                    }
                    return null;
                }
            });
        }

        public <T> T execute(String comment, Callable<T> work) {
            try {
                return (T)Uninterruptibles.getUninterruptibly(this.dbExecutor.submit(work));
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof SQLiteException) {
                    RuntimeException sqlException = this.getSqliteException("Cannot " + comment, ((SQLiteException)t).getBaseErrorCode());
                    sqlException.initCause(e);
                    throw sqlException;
                }
                throw new RuntimeException(e);
            }
        }

        private RuntimeException getSqliteException(String message, int baseErrorCode) {
            switch (baseErrorCode) {
                case 4: {
                    return new SQLiteAbortException(message);
                }
                case 3: {
                    return new SQLiteAccessPermException(message);
                }
                case 25: {
                    return new SQLiteBindOrColumnIndexOutOfRangeException(message);
                }
                case 18: {
                    return new SQLiteBlobTooBigException(message);
                }
                case 14: {
                    return new SQLiteCantOpenDatabaseException(message);
                }
                case 19: {
                    return new SQLiteConstraintException(message);
                }
                case 11: 
                case 26: {
                    return new SQLiteDatabaseCorruptException(message);
                }
                case 5: {
                    return new SQLiteDatabaseLockedException(message);
                }
                case 20: {
                    return new SQLiteDatatypeMismatchException(message);
                }
                case 10: {
                    return new SQLiteDiskIOException(message);
                }
                case 101: {
                    return new SQLiteDoneException(message);
                }
                case 13: {
                    return new SQLiteFullException(message);
                }
                case 21: {
                    return new SQLiteMisuseException(message);
                }
                case 7: {
                    return new SQLiteOutOfMemoryException(message);
                }
                case 8: {
                    return new SQLiteReadOnlyDatabaseException(message);
                }
                case 6: {
                    return new SQLiteTableLockedException(message);
                }
                case 9: {
                    return new OperationCanceledException(message);
                }
            }
            return new android.database.sqlite.SQLiteException(message + ", base error code: " + baseErrorCode);
        }
    }
}

