/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowResourceCursorAdapter;

@Implements(value=SimpleCursorAdapter.class)
public class ShadowSimpleCursorAdapter
extends ShadowResourceCursorAdapter {
    @RealObject
    private SimpleCursorAdapter realSimpleCursorAdapter;
    protected int[] mFrom;
    protected int[] mTo;
    private int mStringConversionColumn = -1;
    private SimpleCursorAdapter.CursorToStringConverter mCursorToStringConverter;
    private SimpleCursorAdapter.ViewBinder mViewBinder;
    private String[] mOriginalFrom;

    public void __constructor__(Context context, int layout, Cursor c, String[] from, int[] to) {
        super.__constructor__(context, layout, c);
        this.mTo = to;
        this.mOriginalFrom = from;
        this.findColumns(from);
    }

    public void __constructor__(Context context, int layout, Cursor c, String[] from, int[] to, int flags) {
        this.__constructor__(context, layout, c, from, to);
    }

    @Implementation
    public void bindView(View view, Context context, Cursor cursor) {
        SimpleCursorAdapter.ViewBinder binder = this.mViewBinder;
        int count = this.mTo.length;
        int[] from = this.mFrom;
        int[] to = this.mTo;
        for (int i = 0; i < count; ++i) {
            View v = view.findViewById(to[i]);
            if (v == null) continue;
            boolean bound = false;
            if (binder != null) {
                bound = binder.setViewValue(v, cursor, from[i]);
            }
            if (bound) continue;
            String text = cursor.getString(from[i]);
            if (text == null) {
                text = "";
            }
            if (v instanceof TextView) {
                this.setViewText((TextView)v, text);
                continue;
            }
            if (v instanceof ImageView) {
                this.setViewImage((ImageView)v, text);
                continue;
            }
            throw new IllegalStateException(v.getClass().getName() + " is not a  view that can be bounds by this SimpleCursorAdapter");
        }
    }

    @Implementation
    public SimpleCursorAdapter.ViewBinder getViewBinder() {
        return this.mViewBinder;
    }

    @Implementation
    public void setViewBinder(SimpleCursorAdapter.ViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
    }

    @Implementation
    public void setViewImage(ImageView v, String value) {
        try {
            v.setImageResource(Integer.parseInt(value));
        }
        catch (NumberFormatException nfe) {
            v.setImageURI(Uri.parse((String)value));
        }
    }

    @Implementation
    public void setViewText(TextView v, String text) {
        v.setText((CharSequence)text);
    }

    @Implementation
    public int getStringConversionColumn() {
        return this.mStringConversionColumn;
    }

    @Implementation
    public void setStringConversionColumn(int stringConversionColumn) {
        this.mStringConversionColumn = stringConversionColumn;
    }

    @Implementation
    public SimpleCursorAdapter.CursorToStringConverter getCursorToStringConverter() {
        return this.mCursorToStringConverter;
    }

    @Implementation
    public void setCursorToStringConverter(SimpleCursorAdapter.CursorToStringConverter cursorToStringConverter) {
        this.mCursorToStringConverter = cursorToStringConverter;
    }

    @Override
    @Implementation
    public CharSequence convertToString(Cursor cursor) {
        if (this.mCursorToStringConverter != null) {
            return this.mCursorToStringConverter.convertToString(cursor);
        }
        if (this.mStringConversionColumn > -1) {
            return cursor.getString(this.mStringConversionColumn);
        }
        return this.realSimpleCursorAdapter.convertToString(cursor);
    }

    private void findColumns(String[] from) {
        if (this.mCursor != null) {
            this.findColumnsFromCursor(this.mCursor, from);
        } else {
            this.mFrom = null;
        }
    }

    private void findColumnsFromCursor(Cursor c, String[] from) {
        if (c != null) {
            int count = from.length;
            if (this.mFrom == null || this.mFrom.length != count) {
                this.mFrom = new int[count];
            }
            for (int i = 0; i < count; ++i) {
                this.mFrom[i] = c.getColumnIndexOrThrow(from[i]);
            }
        } else {
            this.mFrom = null;
        }
    }

    @Override
    @Implementation
    public Cursor swapCursor(Cursor c) {
        this.findColumnsFromCursor(c, this.mOriginalFrom);
        return super.swapCursor(c);
    }

    @Override
    @Implementation
    public void changeCursor(Cursor c) {
        this.findColumnsFromCursor(c, this.mOriginalFrom);
        super.changeCursor(c);
    }

    @Implementation
    public void changeCursorAndColumns(Cursor c, String[] from, int[] to) {
        this.mOriginalFrom = from;
        this.mTo = to;
        this.realSimpleCursorAdapter.changeCursor(c);
        this.findColumns(this.mOriginalFrom);
    }

    @Override
    @Implementation
    public View getView(int position, View convertView, ViewGroup parent) {
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("couldn't move cursor to position " + position);
        }
        View v = convertView == null ? this.newView(this.mContext, this.mCursor, parent) : convertView;
        this.bindView(v, this.mContext, this.mCursor);
        return v;
    }

    @Implementation
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        if (this.mDataValid) {
            this.mCursor.moveToPosition(position);
            View v = convertView == null ? this.newDropDownView(this.mContext, this.mCursor, parent) : convertView;
            this.bindView(v, this.mContext, this.mCursor);
            return v;
        }
        return null;
    }
}

