/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAccessibilityRecord;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityEvent.class)
public class ShadowAccessibilityEvent
extends ShadowAccessibilityRecord {
    private static final Map<StrictEqualityEventWrapper, StackTraceElement[]> obtainedInstances = new HashMap<StrictEqualityEventWrapper, StackTraceElement[]>();
    private static final SparseArray<StrictEqualityEventWrapper> orderedInstances = new SparseArray();
    private static int sAllocationCount = 0;
    private int eventType;
    private CharSequence contentDescription;
    private CharSequence packageName;
    private CharSequence className;
    private boolean enabled;
    @RealObject
    private AccessibilityEvent realAccessibilityEvent;
    public static final Parcelable.Creator<AccessibilityEvent> CREATOR = new Parcelable.Creator<AccessibilityEvent>(){

        public AccessibilityEvent createFromParcel(Parcel source) {
            return ShadowAccessibilityEvent.obtain(((StrictEqualityEventWrapper)orderedInstances.get((int)source.readInt())).mEvent);
        }

        public AccessibilityEvent[] newArray(int size) {
            return new AccessibilityEvent[size];
        }
    };

    @Implementation
    public void __constructor__() {
        ReflectionHelpers.setStaticField(AccessibilityEvent.class, (String)"CREATOR", CREATOR);
    }

    @Implementation
    public static AccessibilityEvent obtain(AccessibilityEvent event) {
        ShadowAccessibilityEvent shadowEvent = (ShadowAccessibilityEvent)Shadow.extract((Object)event);
        AccessibilityEvent obtainedInstance = shadowEvent.getClone();
        StrictEqualityEventWrapper wrapper = new StrictEqualityEventWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(++sAllocationCount, (Object)wrapper);
        return obtainedInstance;
    }

    @Implementation
    public static AccessibilityEvent obtain(int eventType) {
        AccessibilityEvent obtainedInstance = (AccessibilityEvent)ReflectionHelpers.callConstructor(AccessibilityEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityEvent shadowObtained = (ShadowAccessibilityEvent)Shadow.extract((Object)obtainedInstance);
        StrictEqualityEventWrapper wrapper = new StrictEqualityEventWrapper(obtainedInstance);
        obtainedInstances.put(wrapper, Thread.currentThread().getStackTrace());
        orderedInstances.put(++sAllocationCount, (Object)wrapper);
        shadowObtained.eventType = eventType;
        return obtainedInstance;
    }

    @Implementation
    public static AccessibilityEvent obtain() {
        return ShadowAccessibilityEvent.obtain(0);
    }

    public static boolean areThereUnrecycledEvents(boolean printUnrecycledEventsToSystemErr) {
        if (printUnrecycledEventsToSystemErr) {
            for (StrictEqualityEventWrapper wrapper : obtainedInstances.keySet()) {
                ShadowAccessibilityEvent shadow = (ShadowAccessibilityEvent)Shadow.extract((Object)wrapper.mEvent);
                System.err.println(String.format("Leaked AccessibilityEvent type: %d. Stack trace of allocation:", shadow.getEventType()));
                for (StackTraceElement stackTraceElement : obtainedInstances.get(wrapper)) {
                    System.err.println(stackTraceElement.toString());
                }
            }
        }
        return obtainedInstances.size() != 0;
    }

    public static void resetObtainedInstances() {
        obtainedInstances.clear();
        orderedInstances.clear();
    }

    @Implementation
    public void recycle() {
        StrictEqualityEventWrapper wrapper = new StrictEqualityEventWrapper(this.realAccessibilityEvent);
        if (!obtainedInstances.containsKey(wrapper)) {
            throw new IllegalStateException();
        }
        obtainedInstances.remove(wrapper);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            int key = orderedInstances.keyAt(i);
            if (!((StrictEqualityEventWrapper)orderedInstances.get(key)).equals(wrapper)) continue;
            keyOfWrapper = key;
            break;
        }
        orderedInstances.remove(keyOfWrapper);
        this.setParcelableData(null);
    }

    @Implementation
    public void setEventType(int type) {
        this.eventType = type;
    }

    @Implementation
    public int getEventType() {
        return this.eventType;
    }

    @Implementation
    public void setContentDescription(CharSequence description) {
        this.contentDescription = description;
    }

    @Implementation
    public CharSequence getContentDescription() {
        return this.contentDescription;
    }

    @Implementation
    public void setPackageName(CharSequence name) {
        this.packageName = name;
    }

    @Implementation
    public CharSequence getPackageName() {
        return this.packageName;
    }

    @Implementation
    public void setClassName(CharSequence name) {
        this.className = name;
    }

    @Implementation
    public CharSequence getClassName() {
        return this.className;
    }

    @Implementation
    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Implementation
    public boolean isEnabled() {
        return this.enabled;
    }

    @Implementation
    public boolean equals(Object object) {
        if (!(object instanceof AccessibilityEvent)) {
            return false;
        }
        AccessibilityEvent event = (AccessibilityEvent)object;
        ShadowAccessibilityEvent otherShadow = (ShadowAccessibilityEvent)Shadow.extract((Object)event);
        boolean areEqual = this.eventType == otherShadow.eventType;
        areEqual &= this.enabled == otherShadow.enabled;
        areEqual &= TextUtils.equals((CharSequence)this.contentDescription, (CharSequence)otherShadow.contentDescription);
        areEqual &= TextUtils.equals((CharSequence)this.packageName, (CharSequence)otherShadow.packageName);
        areEqual &= TextUtils.equals((CharSequence)this.className, (CharSequence)otherShadow.className);
        boolean parcelableDataEqual = false;
        if (this.getParcelableData() == null && otherShadow.getParcelableData() == null) {
            parcelableDataEqual = true;
        } else if (this.getParcelableData().equals(otherShadow.getParcelableData())) {
            parcelableDataEqual = true;
        }
        return areEqual &= parcelableDataEqual;
    }

    public int hashCode() {
        return 0;
    }

    private AccessibilityEvent getClone() {
        AccessibilityEvent newEvent = (AccessibilityEvent)ReflectionHelpers.callConstructor(AccessibilityEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowAccessibilityEvent newShadow = (ShadowAccessibilityEvent)Shadow.extract((Object)newEvent);
        newShadow.eventType = this.eventType;
        newShadow.contentDescription = this.contentDescription;
        newShadow.packageName = this.packageName;
        newShadow.className = this.className;
        newShadow.enabled = this.enabled;
        newShadow.setParcelableData(this.getParcelableData());
        return newEvent;
    }

    @Implementation
    public int describeContents() {
        return 0;
    }

    @Implementation
    public void writeToParcel(Parcel dest, int flags) {
        StrictEqualityEventWrapper wrapper = new StrictEqualityEventWrapper(this.realAccessibilityEvent);
        int keyOfWrapper = -1;
        for (int i = 0; i < orderedInstances.size(); ++i) {
            if (!((StrictEqualityEventWrapper)orderedInstances.valueAt(i)).equals(wrapper)) continue;
            keyOfWrapper = orderedInstances.keyAt(i);
            break;
        }
        dest.writeInt(keyOfWrapper);
    }

    private static class StrictEqualityEventWrapper {
        public final AccessibilityEvent mEvent;

        public StrictEqualityEventWrapper(AccessibilityEvent event) {
            this.mEvent = event;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            StrictEqualityEventWrapper wrapper = (StrictEqualityEventWrapper)object;
            return this.mEvent == wrapper.mEvent;
        }

        public int hashCode() {
            return this.mEvent.hashCode();
        }
    }
}

