/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AppOpsManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AppOpsManager.class)
public class ShadowAppOpsManager {
    private static final long OP_TIME = 1400000000L;
    private static final long REJECT_TIME = 0L;
    private static final int DURATION = 10;
    private static final int PROXY_UID = 0;
    private static final String PROXY_PACKAGE = "";
    Multimap<String, Integer> mStoredOps = HashMultimap.create();

    @Implementation(minSdk=19)
    public int noteOp(int op, int uid, String packageName) {
        this.mStoredOps.put((Object)ShadowAppOpsManager.getInternalKey(uid, packageName), (Object)op);
        return 0;
    }

    @Implementation(minSdk=19)
    @HiddenApi
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        HashSet<Integer> opFilter = new HashSet<Integer>();
        if (ops != null) {
            for (int op : ops) {
                opFilter.add(op);
            }
        }
        ArrayList<AppOpsManager.OpEntry> opEntries = new ArrayList<AppOpsManager.OpEntry>();
        for (Integer op : this.mStoredOps.get((Object)ShadowAppOpsManager.getInternalKey(uid, packageName))) {
            if (!opFilter.isEmpty() && !opFilter.contains(op)) continue;
            opEntries.add(ShadowAppOpsManager.toOpEntry(op));
        }
        return ImmutableList.of((Object)new AppOpsManager.PackageOps(packageName, uid, opEntries));
    }

    private static AppOpsManager.OpEntry toOpEntry(Integer op) {
        if (RuntimeEnvironment.getApiLevel() < 23) {
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1400000000L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)10)});
        }
        return new AppOpsManager.OpEntry(op.intValue(), 0, 1400000000L, 0L, 10, 0, PROXY_PACKAGE);
    }

    private static String getInternalKey(int uid, String packageName) {
        return uid + "|" + packageName;
    }
}

