/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.AsyncTaskLoader;
import android.content.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=AsyncTaskLoader.class)
public class ShadowAsyncTaskLoader<D> {
    @RealObject
    private AsyncTaskLoader<D> realObject;
    private BackgroundWorker worker;

    @Implementation
    public void __constructor__(Context context) {
        this.worker = new BackgroundWorker();
    }

    @Implementation
    public void onForceLoad() {
        FutureTask future = new FutureTask<D>(this.worker){

            @Override
            protected void done() {
                try {
                    final Object result = this.get();
                    ShadowApplication.getInstance().getForegroundThreadScheduler().post(new Runnable(){

                        @Override
                        public void run() {
                            ShadowAsyncTaskLoader.this.realObject.deliverResult(result);
                        }
                    });
                }
                catch (InterruptedException result) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        };
        ShadowApplication.getInstance().getBackgroundThreadScheduler().post((Runnable)future);
    }

    private final class BackgroundWorker
    implements Callable<D> {
        private BackgroundWorker() {
        }

        @Override
        public D call() throws Exception {
            return ShadowAsyncTaskLoader.this.realObject.loadInBackground();
        }
    }
}

