/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.fakes.RoboIntentSender;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=PendingIntent.class)
public class ShadowPendingIntent {
    private static final List<PendingIntent> createdIntents = new ArrayList<PendingIntent>();
    @RealObject
    private PendingIntent realPendingIntent;
    private Intent[] savedIntents;
    private Context savedContext;
    private Type type;
    private int requestCode;
    private int flags;
    private String creatorPackage;
    private boolean canceled;

    @Implementation
    public static PendingIntent getActivity(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.ACTIVITY, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getActivity(Context context, int requestCode, Intent intent, int flags, Bundle options) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.ACTIVITY, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags) {
        return ShadowPendingIntent.create(context, intents, Type.ACTIVITY, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getActivities(Context context, int requestCode, Intent[] intents, int flags, Bundle options) {
        return ShadowPendingIntent.create(context, intents, Type.ACTIVITY, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getBroadcast(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.BROADCAST, requestCode, flags);
    }

    @Implementation
    public static PendingIntent getService(Context context, int requestCode, Intent intent, int flags) {
        return ShadowPendingIntent.create(context, new Intent[]{intent}, Type.SERVICE, requestCode, flags);
    }

    @Implementation
    public void cancel() {
        Iterator<PendingIntent> i = createdIntents.iterator();
        while (i.hasNext()) {
            PendingIntent pendingIntent = i.next();
            if (pendingIntent != this.realPendingIntent) continue;
            this.canceled = true;
            i.remove();
            break;
        }
    }

    @Implementation
    public void send() throws PendingIntent.CanceledException {
        this.send(this.savedContext, 0, null);
    }

    @Implementation
    public void send(Context context, int code, Intent intent) throws PendingIntent.CanceledException {
        if (this.canceled) {
            throw new PendingIntent.CanceledException();
        }
        if (intent != null && ShadowPendingIntent.isMutable(this.flags)) {
            this.getSavedIntent().fillIn(intent, 0);
        }
        if (this.isActivityIntent()) {
            for (Intent savedIntent : this.savedIntents) {
                context.startActivity(savedIntent);
            }
        } else if (this.isBroadcastIntent()) {
            for (Intent savedIntent : this.savedIntents) {
                context.sendBroadcast(savedIntent);
            }
        } else if (this.isServiceIntent()) {
            for (Intent savedIntent : this.savedIntents) {
                context.startService(savedIntent);
            }
        }
        if (ShadowPendingIntent.isOneShot(this.flags)) {
            this.cancel();
        }
    }

    @Implementation
    public IntentSender getIntentSender() {
        return new RoboIntentSender(this.realPendingIntent);
    }

    public boolean isActivityIntent() {
        return this.type == Type.ACTIVITY;
    }

    public boolean isBroadcastIntent() {
        return this.type == Type.BROADCAST;
    }

    public boolean isServiceIntent() {
        return this.type == Type.SERVICE;
    }

    public Context getSavedContext() {
        return this.savedContext;
    }

    public Intent getSavedIntent() {
        return this.savedIntents[this.savedIntents.length - 1];
    }

    public Intent[] getSavedIntents() {
        return this.savedIntents;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public int getFlags() {
        return this.flags;
    }

    @Implementation
    public String getTargetPackage() {
        return this.getCreatorPackage();
    }

    @Implementation
    public String getCreatorPackage() {
        return this.creatorPackage == null ? RuntimeEnvironment.application.getPackageName() : this.creatorPackage;
    }

    public void setCreatorPackage(String creatorPackage) {
        this.creatorPackage = creatorPackage;
    }

    @Implementation
    public boolean equals(Object o) {
        String thatPackageName;
        if (this == o) {
            return true;
        }
        if (o == null || this.realPendingIntent.getClass() != o.getClass()) {
            return false;
        }
        ShadowPendingIntent that = Shadows.shadowOf((PendingIntent)o);
        String packageName = this.savedContext == null ? null : this.savedContext.getPackageName();
        String string = thatPackageName = that.savedContext == null ? null : that.savedContext.getPackageName();
        if (!Objects.equals(packageName, thatPackageName)) {
            return false;
        }
        if (this.savedIntents.length != that.savedIntents.length) {
            return false;
        }
        for (int i = 0; i < this.savedIntents.length; ++i) {
            if (this.savedIntents[i].filterEquals(that.savedIntents[i])) continue;
            return false;
        }
        return this.requestCode == that.requestCode;
    }

    @Implementation
    public int hashCode() {
        int result;
        int n = result = this.savedIntents != null ? Arrays.hashCode(this.savedIntents) : 0;
        if (this.savedContext != null) {
            String packageName = this.savedContext.getPackageName();
            result = 31 * result + (packageName != null ? packageName.hashCode() : 0);
        }
        result = 31 * result + this.requestCode;
        return result;
    }

    private static PendingIntent create(Context context, Intent[] intents, Type type, int requestCode, int flags) {
        Objects.requireNonNull(intents, "intents may not be null");
        PendingIntent pendingIntent = ShadowPendingIntent.getCreatedIntentFor(type, intents, requestCode, flags);
        if ((flags & 0x20000000) != 0) {
            return pendingIntent;
        }
        if (pendingIntent != null && (flags & 0x8000000) != 0) {
            Intent intent = Shadows.shadowOf(pendingIntent).getSavedIntent();
            Bundle extras = intent.getExtras();
            if (extras != null) {
                extras.clear();
            }
            intent.putExtras(intents[intents.length - 1]);
            return pendingIntent;
        }
        if (pendingIntent != null && (flags & 0x10000000) != 0) {
            ShadowPendingIntent toCancel = Shadows.shadowOf(pendingIntent);
            toCancel.cancel();
            pendingIntent = null;
        }
        if (pendingIntent == null) {
            pendingIntent = (PendingIntent)ReflectionHelpers.callConstructor(PendingIntent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(pendingIntent);
            shadowPendingIntent.savedIntents = intents;
            shadowPendingIntent.type = type;
            shadowPendingIntent.savedContext = context;
            shadowPendingIntent.requestCode = requestCode;
            shadowPendingIntent.flags = flags;
            createdIntents.add(pendingIntent);
        }
        return pendingIntent;
    }

    private static PendingIntent getCreatedIntentFor(Type type, Intent[] intents, int requestCode, int flags) {
        for (PendingIntent createdIntent : createdIntents) {
            ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(createdIntent);
            if (ShadowPendingIntent.isOneShot(shadowPendingIntent.flags) != ShadowPendingIntent.isOneShot(flags) || ShadowPendingIntent.isMutable(shadowPendingIntent.flags) != ShadowPendingIntent.isMutable(flags) || shadowPendingIntent.type != type || shadowPendingIntent.requestCode != requestCode) continue;
            Intent savedIntent = shadowPendingIntent.getSavedIntent();
            Intent targetIntent = intents[intents.length - 1];
            if (!(savedIntent == null ? targetIntent == null : savedIntent.filterEquals(targetIntent))) continue;
            return createdIntent;
        }
        return null;
    }

    private static boolean isOneShot(int flags) {
        return (flags & 0x40000000) != 0;
    }

    private static boolean isMutable(int flags) {
        return (flags & 0x4000000) == 0;
    }

    @Resetter
    public static void reset() {
        createdIntents.clear();
    }

    private static enum Type {
        ACTIVITY,
        BROADCAST,
        SERVICE;

    }
}

