/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityService;
import android.graphics.Region;
import android.os.Handler;
import android.os.Looper;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=AccessibilityService.MagnificationController.class, minSdk=24)
public class ShadowMagnificationController {
    private static final float DEFAULT_CENTER_X = 0.0f;
    private static final float DEFAULT_CENTER_Y = 0.0f;
    private static final float DEFAULT_SCALE = 1.0f;
    @RealObject
    private AccessibilityService.MagnificationController realObject;
    private final HashMap<AccessibilityService.MagnificationController.OnMagnificationChangedListener, Handler> listeners = new HashMap();
    private final Region magnificationRegion = new Region();
    private float centerX = 0.0f;
    private float centerY = 0.0f;
    private float scale = 1.0f;

    @Implementation
    protected void addListener(AccessibilityService.MagnificationController.OnMagnificationChangedListener listener, Handler handler) {
        this.listeners.put(listener, handler);
    }

    @Implementation
    protected void addListener(AccessibilityService.MagnificationController.OnMagnificationChangedListener listener) {
        this.addListener(listener, new Handler(Looper.getMainLooper()));
    }

    @Implementation
    protected float getCenterX() {
        return this.centerX;
    }

    @Implementation
    protected float getCenterY() {
        return this.centerY;
    }

    @Implementation
    protected Region getMagnificationRegion() {
        return this.magnificationRegion;
    }

    @Implementation
    protected float getScale() {
        return this.scale;
    }

    @Implementation
    protected boolean removeListener(AccessibilityService.MagnificationController.OnMagnificationChangedListener listener) {
        if (!this.listeners.containsKey(listener)) {
            return false;
        }
        this.listeners.remove(listener);
        return true;
    }

    @Implementation
    protected boolean reset(boolean animate) {
        this.centerX = 0.0f;
        this.centerY = 0.0f;
        this.scale = 1.0f;
        this.notifyListeners();
        return true;
    }

    @Implementation
    protected boolean setCenter(float centerX, float centerY, boolean animate) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.notifyListeners();
        return true;
    }

    @Implementation
    protected boolean setScale(float scale, boolean animate) {
        this.scale = scale;
        this.notifyListeners();
        return true;
    }

    private void notifyListeners() {
        for (AccessibilityService.MagnificationController.OnMagnificationChangedListener listener : this.listeners.keySet()) {
            Handler handler = this.listeners.get(listener);
            handler.post(() -> listener.onMagnificationChanged(this.realObject, this.magnificationRegion, this.scale, this.centerX, this.centerY));
        }
    }
}

