/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.UserHandle;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=LauncherApps.class, minSdk=21)
public class ShadowLauncherApps {
    private List<ShortcutInfo> shortcuts = new ArrayList<ShortcutInfo>();
    private final Multimap<UserHandle, String> enabledPackages = HashMultimap.create();
    private final Multimap<UserHandle, LauncherActivityInfo> shortcutActivityList = HashMultimap.create();
    private final Multimap<UserHandle, LauncherActivityInfo> activityList = HashMultimap.create();
    private final Map<UserHandle, Map<String, ApplicationInfo>> applicationInfoList = new HashMap<UserHandle, Map<String, ApplicationInfo>>();
    private final Map<UserHandle, Map<String, Bundle>> suspendedPackageLauncherExtras = new HashMap<UserHandle, Map<String, Bundle>>();
    private final List<Pair<LauncherApps.Callback, Handler>> callbacks = new ArrayList<Pair<LauncherApps.Callback, Handler>>();
    private boolean hasShortcutHostPermission = false;

    public void addDynamicShortcut(ShortcutInfo shortcutInfo) {
        this.shortcuts.add(shortcutInfo);
        this.shortcutsChanged(shortcutInfo.getPackage(), Lists.newArrayList((Object[])new ShortcutInfo[]{shortcutInfo}));
    }

    private void shortcutsChanged(String packageName, List<ShortcutInfo> shortcuts) {
        for (Pair<LauncherApps.Callback, Handler> callbackPair : this.callbacks) {
            ((Handler)callbackPair.second).post(() -> ((LauncherApps.Callback)callbackPair.first).onShortcutsChanged(packageName, shortcuts, Process.myUserHandle()));
        }
    }

    public void notifyPackageAdded(String packageName) {
        for (Pair<LauncherApps.Callback, Handler> callbackPair : this.callbacks) {
            ((Handler)callbackPair.second).post(() -> ((LauncherApps.Callback)callbackPair.first).onPackageAdded(packageName, Process.myUserHandle()));
        }
    }

    public void addEnabledPackage(UserHandle userHandle, String packageName) {
        this.enabledPackages.put((Object)userHandle, (Object)packageName);
    }

    public void addShortcutConfigActivity(UserHandle userHandle, LauncherActivityInfo activityInfo) {
        this.shortcutActivityList.put((Object)userHandle, (Object)activityInfo);
    }

    public void addActivity(UserHandle userHandle, LauncherActivityInfo activityInfo) {
        this.activityList.put((Object)userHandle, (Object)activityInfo);
    }

    public void notifyPackageRemoved(String packageName) {
        for (Pair<LauncherApps.Callback, Handler> callbackPair : this.callbacks) {
            ((Handler)callbackPair.second).post(() -> ((LauncherApps.Callback)callbackPair.first).onPackageRemoved(packageName, Process.myUserHandle()));
        }
    }

    public void addApplicationInfo(UserHandle userHandle, String packageName, ApplicationInfo applicationInfo) {
        if (!this.applicationInfoList.containsKey(userHandle)) {
            this.applicationInfoList.put(userHandle, new HashMap());
        }
        this.applicationInfoList.get(userHandle).put(packageName, applicationInfo);
    }

    @Implementation(minSdk=29)
    protected void startPackageInstallerSessionDetailsActivity(@NonNull PackageInstaller.SessionInfo sessionInfo, @Nullable Rect sourceBounds, @Nullable Bundle opts) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation
    protected void startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation(minSdk=26)
    protected List<LauncherActivityInfo> getShortcutConfigActivityList(@Nullable String packageName, @NonNull UserHandle user) {
        return this.shortcutActivityList.get((Object)user).stream().filter(this.matchesPackage(packageName)).collect(Collectors.toList());
    }

    @Implementation(minSdk=26)
    @Nullable
    protected IntentSender getShortcutConfigActivityIntent(@NonNull LauncherActivityInfo info) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation
    protected boolean isPackageEnabled(String packageName, UserHandle user) {
        return this.enabledPackages.get((Object)user).contains(packageName);
    }

    @Implementation(minSdk=21)
    protected List<LauncherActivityInfo> getActivityList(String packageName, UserHandle user) {
        return this.activityList.get((Object)user).stream().filter(this.matchesPackage(packageName)).collect(Collectors.toList());
    }

    @Implementation(minSdk=26)
    protected ApplicationInfo getApplicationInfo(@NonNull String packageName, int flags, @NonNull UserHandle user) throws PackageManager.NameNotFoundException {
        Map<String, ApplicationInfo> map;
        if (this.applicationInfoList.containsKey(user) && (map = this.applicationInfoList.get(user)).containsKey(packageName)) {
            return map.get(packageName);
        }
        throw new PackageManager.NameNotFoundException("Package " + packageName + " not found for user " + user.getIdentifier());
    }

    public void addSuspendedPackageLauncherExtras(UserHandle userHandle, String packageName, Bundle bundle) {
        if (!this.suspendedPackageLauncherExtras.containsKey(userHandle)) {
            this.suspendedPackageLauncherExtras.put(userHandle, new HashMap());
        }
        this.suspendedPackageLauncherExtras.get(userHandle).put(packageName, bundle);
    }

    @Implementation(minSdk=28)
    @Nullable
    protected Bundle getSuspendedPackageLauncherExtras(String packageName, UserHandle user) throws PackageManager.NameNotFoundException {
        Map<String, Bundle> map = this.suspendedPackageLauncherExtras.get(user);
        if (map != null && map.containsKey(packageName)) {
            return map.get(packageName);
        }
        throw new PackageManager.NameNotFoundException("Suspended package extras for  " + packageName + " not found for user " + user.getIdentifier());
    }

    @Implementation(minSdk=29)
    protected boolean shouldHideFromSuggestions(@NonNull String packageName, @NonNull UserHandle user) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation
    protected boolean isActivityEnabled(ComponentName component, UserHandle user) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    public void setHasShortcutHostPermission(boolean permission2) {
        this.hasShortcutHostPermission = permission2;
    }

    @Implementation(minSdk=24)
    protected boolean hasShortcutHostPermission() {
        return this.hasShortcutHostPermission;
    }

    @Implementation(minSdk=25)
    @Nullable
    protected List<ShortcutInfo> getShortcuts(@NonNull LauncherApps.ShortcutQuery query, @NonNull UserHandle user) {
        String packageName;
        ComponentName activity;
        if (((ReflectorShortcutQuery)Reflector.reflector(ReflectorShortcutQuery.class, (Object)query)).getChangedSince() != 0L) {
            throw new UnsupportedOperationException("Robolectric does not currently support ShortcutQueries that filter on time since change.");
        }
        int flags = ((ReflectorShortcutQuery)Reflector.reflector(ReflectorShortcutQuery.class, (Object)query)).getQueryFlags();
        if ((flags & 2) == 0 || (flags & 1) == 0) {
            throw new UnsupportedOperationException("Robolectric does not currently support ShortcutQueries that match non-dynamic Shortcuts.");
        }
        Iterable<Object> shortcutsItr = this.shortcuts;
        List<String> ids = ((ReflectorShortcutQuery)Reflector.reflector(ReflectorShortcutQuery.class, (Object)query)).getShortcutIds();
        if (ids != null) {
            shortcutsItr = Iterables.filter(shortcutsItr, shortcut -> ids.contains(shortcut.getId()));
        }
        if ((activity = ((ReflectorShortcutQuery)Reflector.reflector(ReflectorShortcutQuery.class, (Object)query)).getActivity()) != null) {
            shortcutsItr = Iterables.filter(shortcutsItr, shortcut -> shortcut.getActivity().equals((Object)activity));
        }
        if ((packageName = ((ReflectorShortcutQuery)Reflector.reflector(ReflectorShortcutQuery.class, (Object)query)).getPackage()) != null && !packageName.isEmpty()) {
            shortcutsItr = Iterables.filter(shortcutsItr, shortcut -> shortcut.getPackage().equals(packageName));
        }
        return Lists.newArrayList(shortcutsItr);
    }

    @Implementation(minSdk=25)
    protected void pinShortcuts(@NonNull String packageName, @NonNull List<String> shortcutIds, @NonNull UserHandle user) {
        Iterable changed = Iterables.filter(this.shortcuts, shortcut -> !shortcutIds.contains(shortcut.getId()));
        ArrayList ret = Lists.newArrayList((Iterable)changed);
        this.shortcuts = Lists.newArrayList((Iterable)Iterables.filter(this.shortcuts, shortcut -> shortcutIds.contains(shortcut.getId())));
        this.shortcutsChanged(packageName, ret);
    }

    @Implementation(minSdk=25)
    protected void startShortcut(@NonNull String packageName, @NonNull String shortcutId, @Nullable Rect sourceBounds, @Nullable Bundle startActivityOptions, @NonNull UserHandle user) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation(minSdk=25)
    protected void startShortcut(@NonNull ShortcutInfo shortcut, @Nullable Rect sourceBounds, @Nullable Bundle startActivityOptions) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation
    protected void registerCallback(LauncherApps.Callback callback) {
        this.registerCallback(callback, null);
    }

    @Implementation
    protected void registerCallback(LauncherApps.Callback callback, Handler handler) {
        this.callbacks.add((Pair<LauncherApps.Callback, Handler>)Pair.create((Object)callback, (Object)(handler != null ? handler : new Handler(Looper.myLooper()))));
    }

    @Implementation
    protected void unregisterCallback(LauncherApps.Callback callback) {
        int index = Iterables.indexOf(this.callbacks, pair -> pair.first == callback);
        if (index != -1) {
            this.callbacks.remove(index);
        }
    }

    @Implementation(minSdk=29)
    protected void registerPackageInstallerSessionCallback(@NonNull Executor executor, @NonNull PackageInstaller.SessionCallback callback) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation(minSdk=29)
    protected void unregisterPackageInstallerSessionCallback(@NonNull PackageInstaller.SessionCallback callback) {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    @Implementation(minSdk=29)
    @NonNull
    protected List<PackageInstaller.SessionInfo> getAllPackageInstallerSessions() {
        throw new UnsupportedOperationException("This method is not currently supported in Robolectric.");
    }

    private Predicate<LauncherActivityInfo> matchesPackage(@Nullable String packageName) {
        return info -> packageName == null || info.getComponentName() != null && packageName.equals(info.getComponentName().getPackageName());
    }

    @ForType(value=LauncherApps.ShortcutQuery.class)
    private static interface ReflectorShortcutQuery {
        @Accessor(value="mChangedSince")
        public long getChangedSince();

        @Accessor(value="mQueryFlags")
        public int getQueryFlags();

        @Accessor(value="mShortcutIds")
        public List<String> getShortcutIds();

        @Accessor(value="mActivity")
        public ComponentName getActivity();

        @Accessor(value="mPackage")
        public String getPackage();
    }
}

