/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.Phone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInCallAdapter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Phone.class, isInAndroidSdk=false)
public class ShadowPhone {
    @RealObject
    private Phone phone;
    private final List<Call> calls = new ArrayList<Call>();

    @Implementation(minSdk=23)
    protected final List<Call> getCalls() {
        List<Call> unmodifiableCalls = ((ReflectorPhone)Reflector.reflector(ReflectorPhone.class, (Object)this.phone)).getUnmodifiableCalls();
        if (unmodifiableCalls != null) {
            return unmodifiableCalls;
        }
        return Collections.unmodifiableList(this.calls);
    }

    @Implementation(minSdk=23)
    protected final CallAudioState getCallAudioState() {
        CallAudioState callAudioState = ((ReflectorPhone)Reflector.reflector(ReflectorPhone.class, (Object)this.phone)).getCallAudioState();
        if (callAudioState != null) {
            return callAudioState;
        }
        InCallAdapter inCallAdapter = (InCallAdapter)ReflectionHelpers.getField((Object)this.phone, (String)"mInCallAdapter");
        int audioRoute = ((ShadowInCallAdapter)Shadow.extract((Object)inCallAdapter)).getAudioRoute();
        return new CallAudioState(false, audioRoute, 9);
    }

    public void addCall(Call call) {
        this.calls.add(call);
        List<Call> realCalls = ((ReflectorPhone)Reflector.reflector(ReflectorPhone.class, (Object)this.phone)).getCalls();
        if (realCalls != null) {
            realCalls.add(call);
        }
    }

    public void removeCall(Call call) {
        this.calls.remove(call);
        List<Call> realCalls = ((ReflectorPhone)Reflector.reflector(ReflectorPhone.class, (Object)this.phone)).getCalls();
        if (realCalls != null) {
            realCalls.remove(call);
        }
    }

    @ForType(value=Phone.class)
    static interface ReflectorPhone {
        @Accessor(value="mUnmodifiableCalls")
        public List<Call> getUnmodifiableCalls();

        @Accessor(value="mCalls")
        public List<Call> getCalls();

        @Accessor(value="mCallAudioState")
        public CallAudioState getCallAudioState();
    }
}

