/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.os.Binder;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.WindowManagerGlobal;
import androidx.annotation.Nullable;
import java.lang.reflect.Proxy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=WindowManagerGlobal.class, isInAndroidSdk=false, minSdk=17, looseSignatures=true)
public class ShadowWindowManagerGlobal {
    private static WindowSessionDelegate windowSessionDelegate = new WindowSessionDelegate();
    private static IWindowSession windowSession;

    @Resetter
    public static void reset() {
        ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setDefaultWindowManager(null);
        windowSessionDelegate = new WindowSessionDelegate();
        windowSession = null;
    }

    public static boolean getInTouchMode() {
        return windowSessionDelegate.getInTouchMode();
    }

    static void setInTouchMode(boolean inTouchMode) {
        windowSessionDelegate.setInTouchMode(inTouchMode);
    }

    @Nullable
    public static ClipData getLastDragClipData() {
        return ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData;
    }

    public static void clearLastDragClipData() {
        ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData = null;
    }

    @Implementation(minSdk=18)
    protected static synchronized IWindowSession getWindowSession() {
        if (windowSession == null) {
            windowSession = (IWindowSession)Proxy.newProxyInstance(IWindowSession.class.getClassLoader(), new Class[]{IWindowSession.class}, (proxy, method, args) -> {
                String methodName;
                switch (methodName = method.getName()) {
                    case "add": 
                    case "addToDisplay": 
                    case "addToDisplayAsUser": {
                        return windowSessionDelegate.getAddFlags();
                    }
                    case "getInTouchMode": {
                        return windowSessionDelegate.getInTouchMode();
                    }
                    case "performDrag": {
                        return windowSessionDelegate.performDrag(args);
                    }
                    case "prepareDrag": {
                        return windowSessionDelegate.prepareDrag();
                    }
                    case "setInTouchMode": {
                        windowSessionDelegate.setInTouchMode((Boolean)args[0]);
                        return null;
                    }
                }
                return ReflectionHelpers.defaultValueForType((String)method.getReturnType().getName());
            });
        }
        return windowSession;
    }

    @Implementation(maxSdk=17)
    protected static Object getWindowSession(Looper looper) {
        return ShadowWindowManagerGlobal.getWindowSession();
    }

    @Implementation
    protected static synchronized IWindowSession peekWindowSession() {
        return windowSession;
    }

    @Implementation
    public static Object getWindowManagerService() throws RemoteException {
        IWindowManager service = ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).getWindowManagerService();
        if (service == null) {
            service = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
            ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setWindowManagerService(service);
            if (RuntimeEnvironment.getApiLevel() >= 30) {
                ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setUseBlastAdapter(service.useBLAST());
            }
        }
        return service;
    }

    private static class WindowSessionDelegate {
        static final int ADD_FLAG_IN_TOUCH_MODE = 1;
        static final int ADD_FLAG_APP_VISIBLE = 2;
        private boolean inTouchMode = ShadowView.useRealGraphics();
        @Nullable
        protected ClipData lastDragClipData;

        private WindowSessionDelegate() {
        }

        protected int getAddFlags() {
            int res = 0;
            if (ShadowView.useRealGraphics() || "true".equals(System.getProperty("robolectric.areWindowsMarkedVisible", "false"))) {
                res |= 2;
            }
            if (this.getInTouchMode()) {
                res |= 1;
            }
            return res;
        }

        public boolean getInTouchMode() {
            return this.inTouchMode;
        }

        public void setInTouchMode(boolean inTouchMode) {
            this.inTouchMode = inTouchMode;
        }

        public IBinder prepareDrag() {
            return new Binder();
        }

        public Object performDrag(Object[] args) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (!(args[i] instanceof ClipData)) continue;
                this.lastDragClipData = (ClipData)args[i];
                return RuntimeEnvironment.getApiLevel() >= 28 ? new Binder() : Boolean.valueOf(true);
            }
            throw new AssertionError((Object)"Missing ClipData param");
        }
    }

    @ForType(value=WindowManagerGlobal.class)
    static interface WindowManagerGlobalReflector {
        @Accessor(value="sDefaultWindowManager")
        @Static
        public void setDefaultWindowManager(WindowManagerGlobal var1);

        @Static
        @Accessor(value="sWindowManagerService")
        public IWindowManager getWindowManagerService();

        @Static
        @Accessor(value="sWindowManagerService")
        public void setWindowManagerService(IWindowManager var1);

        @Static
        @Accessor(value="sUseBLASTAdapter")
        public void setUseBlastAdapter(boolean var1);
    }
}

