/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.backup.BackupDataInput;
import com.google.common.collect.ImmutableList;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.shadows.BackupDataEntity;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class BackupDataInputBuilder {
    private final List<BackupDataEntity> entities = new ArrayList<BackupDataEntity>();

    private BackupDataInputBuilder() {
    }

    public static BackupDataInputBuilder newBuilder() {
        return new BackupDataInputBuilder();
    }

    public BackupDataInputBuilder addEntity(BackupDataEntity entity) {
        this.entities.add(entity);
        return this;
    }

    public BackupDataInput build() {
        BackupDataInput data = ((BackupDataInputReflector)Reflector.reflector(BackupDataInputReflector.class)).newBackupDataInput(new FileDescriptor());
        Shadows.shadowOf(data).setEntities((ImmutableList<BackupDataEntity>)ImmutableList.copyOf(this.entities));
        return data;
    }

    @ForType(value=BackupDataInput.class)
    private static interface BackupDataInputReflector {
        @Constructor
        public BackupDataInput newBackupDataInput(FileDescriptor var1);
    }
}

