/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.SharedMemory;
import android.service.voice.AlwaysOnHotwordDetector;
import android.service.voice.HotwordDetectedResult;
import android.service.voice.IVoiceInteractionService;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPausedAsyncTask;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AlwaysOnHotwordDetector.class, minSdk=21, isInAndroidSdk=false)
public class ShadowAlwaysOnHotwordDetector {
    @RealObject
    private AlwaysOnHotwordDetector realObject;

    @Implementation(maxSdk=29)
    protected void __constructor__(String text, Locale locale, AlwaysOnHotwordDetector.Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService voiceInteractionService, IVoiceInteractionManagerService modelManagementService) {
        Shadow.invokeConstructor(AlwaysOnHotwordDetector.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)text), ReflectionHelpers.ClassParameter.from(Locale.class, (Object)locale), ReflectionHelpers.ClassParameter.from(AlwaysOnHotwordDetector.Callback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(KeyphraseEnrollmentInfo.class, (Object)keyphraseEnrollmentInfo), ReflectionHelpers.ClassParameter.from(IVoiceInteractionService.class, (Object)voiceInteractionService), ReflectionHelpers.ClassParameter.from(IVoiceInteractionManagerService.class, (Object)modelManagementService)});
        this.setEnrollmentFields(text, locale, keyphraseEnrollmentInfo);
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected void __constructor__(String text, Locale locale, AlwaysOnHotwordDetector.Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionManagerService modelManagementService) {
        Shadow.invokeConstructor(AlwaysOnHotwordDetector.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)text), ReflectionHelpers.ClassParameter.from(Locale.class, (Object)locale), ReflectionHelpers.ClassParameter.from(AlwaysOnHotwordDetector.Callback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(KeyphraseEnrollmentInfo.class, (Object)keyphraseEnrollmentInfo), ReflectionHelpers.ClassParameter.from(IVoiceInteractionManagerService.class, (Object)modelManagementService)});
        this.setEnrollmentFields(text, locale, keyphraseEnrollmentInfo);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected void __constructor__(String text, Locale locale, AlwaysOnHotwordDetector.Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionManagerService modelManagementService, int targetSdkVersion, boolean supportHotwordDetectionService, PersistableBundle options, SharedMemory sharedMemory) {
        Shadow.invokeConstructor(AlwaysOnHotwordDetector.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)text), ReflectionHelpers.ClassParameter.from(Locale.class, (Object)locale), ReflectionHelpers.ClassParameter.from(AlwaysOnHotwordDetector.Callback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(KeyphraseEnrollmentInfo.class, (Object)keyphraseEnrollmentInfo), ReflectionHelpers.ClassParameter.from(IVoiceInteractionManagerService.class, (Object)modelManagementService), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)targetSdkVersion), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)supportHotwordDetectionService), ReflectionHelpers.ClassParameter.from(PersistableBundle.class, (Object)options), ReflectionHelpers.ClassParameter.from(SharedMemory.class, (Object)sharedMemory)});
        this.setEnrollmentFields(text, locale, keyphraseEnrollmentInfo);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected void __constructor__(String text, Locale locale, Executor executor, AlwaysOnHotwordDetector.Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionManagerService modelManagementService, int targetSdkVersion, boolean supportSandboxedDetectionService) {
        Shadow.invokeConstructor(AlwaysOnHotwordDetector.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)text), ReflectionHelpers.ClassParameter.from(Locale.class, (Object)locale), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(AlwaysOnHotwordDetector.Callback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(KeyphraseEnrollmentInfo.class, (Object)keyphraseEnrollmentInfo), ReflectionHelpers.ClassParameter.from(IVoiceInteractionManagerService.class, (Object)modelManagementService), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)targetSdkVersion), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)supportSandboxedDetectionService)});
        this.setEnrollmentFields(text, locale, keyphraseEnrollmentInfo);
    }

    public void triggerOnErrorCallback() {
        ((AlwaysOnHotwordDetectorReflector)Reflector.reflector(AlwaysOnHotwordDetectorReflector.class, (Object)this.realObject)).getCallback().onError();
    }

    public void triggerOnDetectedCallback(AlwaysOnHotwordDetector.EventPayload eventPayload) {
        ((AlwaysOnHotwordDetectorReflector)Reflector.reflector(AlwaysOnHotwordDetectorReflector.class, (Object)this.realObject)).getCallback().onDetected(eventPayload);
    }

    private void setEnrollmentFields(String text, Locale locale, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo) {
        ((AlwaysOnHotwordDetectorReflector)Reflector.reflector(AlwaysOnHotwordDetectorReflector.class, (Object)this.realObject)).setAvailability(2);
        if (RuntimeEnvironment.getApiLevel() > 29 && keyphraseEnrollmentInfo != null) {
            ((AlwaysOnHotwordDetectorReflector)Reflector.reflector(AlwaysOnHotwordDetectorReflector.class, (Object)this.realObject)).setKeyphraseMetadata(keyphraseEnrollmentInfo.getKeyphraseMetadata(text, locale));
        }
    }

    public static AlwaysOnHotwordDetector.EventPayload createEventPayload(boolean triggerAvailable, boolean captureAvailable, AudioFormat audioFormat, int captureSession, byte[] data) {
        if (RuntimeEnvironment.getApiLevel() <= 29) {
            return ((EventPayloadReflector)Reflector.reflector(EventPayloadReflector.class)).newEventPayload(triggerAvailable, captureAvailable, audioFormat, captureSession, data);
        }
        if (RuntimeEnvironment.getApiLevel() == 33) {
            return ((EventPayloadReflector)Reflector.reflector(EventPayloadReflector.class)).newEventPayload(captureAvailable, audioFormat, captureSession, 1, data, null, null, new ArrayList<SoundTrigger.KeyphraseRecognitionExtra>());
        }
        return ((EventPayloadReflector)Reflector.reflector(EventPayloadReflector.class)).newEventPayload(captureAvailable, audioFormat, captureSession, 1, data, null, null, new ArrayList<SoundTrigger.KeyphraseRecognitionExtra>(), 0L);
    }

    @ForType(value=AlwaysOnHotwordDetector.class)
    static interface AlwaysOnHotwordDetectorReflector {
        @Accessor(value="mAvailability")
        public void setAvailability(int var1);

        @Accessor(value="mKeyphraseMetadata")
        public void setKeyphraseMetadata(KeyphraseMetadata var1);

        @Accessor(value="mExternalCallback")
        public AlwaysOnHotwordDetector.Callback getCallback();
    }

    @ForType(value=AlwaysOnHotwordDetector.EventPayload.class)
    static interface EventPayloadReflector {
        @Constructor
        public AlwaysOnHotwordDetector.EventPayload newEventPayload(boolean var1, boolean var2, AudioFormat var3, int var4, byte[] var5);

        @Constructor
        public AlwaysOnHotwordDetector.EventPayload newEventPayload(boolean var1, AudioFormat var2, int var3, int var4, byte[] var5, @Nullable HotwordDetectedResult var6, @Nullable ParcelFileDescriptor var7, @Nonnull List<SoundTrigger.KeyphraseRecognitionExtra> var8);

        @Constructor
        public AlwaysOnHotwordDetector.EventPayload newEventPayload(boolean var1, AudioFormat var2, int var3, int var4, byte[] var5, @Nullable HotwordDetectedResult var6, @Nullable ParcelFileDescriptor var7, @Nonnull List<SoundTrigger.KeyphraseRecognitionExtra> var8, long var9);
    }

    @Implements(className="android.service.voice.AlwaysOnHotwordDetector$RefreshAvailabiltyTask", minSdk=21, maxSdk=33, isInAndroidSdk=false)
    public static class ShadowRefreshAvailabilityTask<Params, Progress, Result>
    extends ShadowPausedAsyncTask<Params, Progress, Result> {
        @Implementation
        protected int internalGetInitialAvailability() {
            return 2;
        }

        @Implementation
        protected boolean internalGetIsEnrolled(int keyphraseId, Locale locale) {
            return true;
        }

        @Implementation(minSdk=30)
        protected void internalUpdateEnrolledKeyphraseMetadata() {
        }
    }
}

