/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import android.system.StructStat;
import java.io.File;
import java.io.FileDescriptor;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.OsConstantsValues;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="libcore.io.Posix", maxSdk=25, isInAndroidSdk=false)
public class ShadowPosix {
    @Implementation
    public void mkdir(String path, int mode) throws ErrnoException {
        new File(path).mkdirs();
    }

    @Implementation
    public static Object stat(String path) throws ErrnoException {
        int mode = OsConstantsValues.getMode(path);
        long size = 0L;
        long modifiedTime = 0L;
        if (path != null) {
            File file = new File(path);
            size = file.length();
            modifiedTime = Duration.ofMillis(file.lastModified()).getSeconds();
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return new StructStat(1L, 0L, mode, 0L, 0, 0, 0L, size, 0L, modifiedTime, 0L, 0L, 0L);
        }
        Object structStat = ReflectionHelpers.newInstance((Class)ReflectionHelpers.loadClass((ClassLoader)ShadowPosix.class.getClassLoader(), (String)"libcore.io.StructStat"));
        ShadowPosix.setMode(mode, structStat);
        ShadowPosix.setSize(size, structStat);
        ShadowPosix.setModifiedTime(modifiedTime, structStat);
        return structStat;
    }

    @Implementation
    protected static Object lstat(String path) throws ErrnoException {
        return ShadowPosix.stat(path);
    }

    @Implementation
    protected static Object fstat(FileDescriptor fd) throws ErrnoException {
        return ShadowPosix.stat(null);
    }

    private static void setMode(int mode, Object structStat) {
        ReflectionHelpers.setField((Object)structStat, (String)"st_mode", (Object)mode);
    }

    private static void setSize(long size, Object structStat) {
        ReflectionHelpers.setField((Object)structStat, (String)"st_size", (Object)size);
    }

    private static void setModifiedTime(long modifiedTime, Object structStat) {
        ReflectionHelpers.setField((Object)structStat, (String)"st_mtime", (Object)modifiedTime);
    }
}

